jQuery(document)
    .ready(function() {

    jQuery(document)
        .on("click", ".calendar_area .calendarheader i", function() {
          // TODO anderen Ladescreen oder Spinner anzeigen
          //jQuery(ajaxloader).fadeIn();
          var parent = jQuery(this).parents(".calendar_area");
          var currentMonth =  jQuery(parent).data("calendar-month");
          var currentYear =  jQuery(parent).data("calendar-year");
          var calendarId =  jQuery(parent).data("calendar-id");
          var operatorId =  jQuery(parent).data("calendar-operator-id");
          var action = jQuery(this).data("action");

          var requestMonth = currentMonth;
          var requestYear = currentYear;
          if(action == "previous")
          {
            if(currentMonth == 1)
            {
              requestMonth = 12;
              requestYear = currentYear - 1;
            }
            else {
              requestMonth = currentMonth - 1;
            }
          }
          else if(action == "next")
          {
            if(currentMonth == 12)
            {
              requestMonth = 1;
              requestYear = currentYear + 1;
            }
            else {
              requestMonth = currentMonth + 1;
            }
          }

          jQuery.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]')
                      .attr('content')
              }
          });

          // Request new Calendar
          jQuery.ajax({
              method: 'GET',
              url: '/operator/calendar/requestCalendar',
              data: {
                  'month': requestMonth,
                  'year': requestYear,
                  'operator_id': operatorId
              },
              success: function(response) {
                  console.log(response.html);
                  jQuery(".calendar_area[data-calendar-id="+calendarId+"]").replaceWith(response.html);
                  addStatusBoxes();
                  // Tooltips erneut aktivieren
                  // TODO beim Umschalten der Monate bleibt der Tooltip offen
                  //jQuery('[data-toggle="tooltip"]').tooltip('disable')
                  //jQuery('.calendar_area [data-toggle="tooltip"]').tooltip('enable');
                  // TODO anderen Ladescreen oder Spinner anzeigen
                  //jQuery(ajaxloader).fadeOut("slow");
              },
              error: function(jqXHR, textStatus, errorThrown) {
                  console.log(JSON.stringify(jqXHR));
                  console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                  // TODO anderen Ladescreen oder Spinner anzeigen
                  //jQuery(ajaxloader).fadeOut("slow");
              }
          });
    });
});


function dragAppointmentToNewDate(appointmentid, operator, datescheduled)
{
  jQuery.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]')
              .attr('content')
      }
  });

  // Request new Calendar
  jQuery.ajax({
      method: 'POST',
      url: '/operator/calendar/updateAppointmentOperator',
      data: {
          'appointment_id': appointmentid,
          'day': datescheduled,
          'operator_id': operator
      },
      success: function(response) {
          //console.log(response.html);
          //console.log("lol"+response.info);
          //jQuery(".calendar_area[data-calendar-id="+calendarId+"]").replaceWith(response.html);
          //addStatusBoxes();
          // Tooltips erneut aktivieren
          // TODO beim Umschalten der Monate bleibt der Tooltip offen
          //jQuery('[data-toggle="tooltip"]').tooltip('disable')
          //jQuery('.calendar_area [data-toggle="tooltip"]').tooltip('enable');
          // TODO anderen Ladescreen oder Spinner anzeigen
          //jQuery(ajaxloader).fadeOut("slow");
      },
      error: function(jqXHR, textStatus, errorThrown) {
          console.log(JSON.stringify(jqXHR));
          console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
          // TODO anderen Ladescreen oder Spinner anzeigen
          //jQuery(ajaxloader).fadeOut("slow");
      }
  });
}


function updateOperatorCalendar(operator, timestamp, status)
{
  jQuery.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]')
              .attr('content')
      }
  });

  // Request new Calendar
  jQuery.ajax({
      method: 'POST',
      url: '/operator/calendar/updateOperatorCalendar',
      data: {
          'status': status,
          'day': timestamp,
          'operator_id': operator
      },
      success: function(response) {
          //console.log(response.html);
          //console.log("lol"+response.info);
          //jQuery(".calendar_area[data-calendar-id="+calendarId+"]").replaceWith(response.html);
          //addStatusBoxes();
          // Tooltips erneut aktivieren
          // TODO beim Umschalten der Monate bleibt der Tooltip offen
          //jQuery('[data-toggle="tooltip"]').tooltip('disable')
          //jQuery('.calendar_area [data-toggle="tooltip"]').tooltip('enable');
          // TODO anderen Ladescreen oder Spinner anzeigen
          //jQuery(ajaxloader).fadeOut("slow");
      },
      error: function(jqXHR, textStatus, errorThrown) {
          console.log(JSON.stringify(jqXHR));
          console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
          // TODO anderen Ladescreen oder Spinner anzeigen
          //jQuery(ajaxloader).fadeOut("slow");
      }
  });
}




	var addBoxRegular = '<div class="setstatusbox">';
	addBoxRegular += '<i class="fal fa-plane-alt" title="Urlaub" data-day-action="1" data-action="setVacation"></i>';
	addBoxRegular += '<i class="fal fa-user-md" data-day-action="1" title="Krank" data-action="setIll"></i>';
	addBoxRegular += '</div>';

function addStatusBoxes()
{
  jQuery(".board-column:not(.weekend) .board-column-header").each(function( index ) {
    jQuery(this).append(addBoxRegular);
  });
}

jQuery(document).ready(function(){
	console.log("ready");
	/*
		<i class="fal fa-plane-alt"></i>
		<i class="fal fa-user-md"></i>
	*/
  addStatusBoxes();

	jQuery(document)
	.on("click", "[data-day-action=1]", function() {
		var action = jQuery(this).data("action");
		var parent = jQuery(this).parents(".board-column");

    var operatorId = jQuery(parent).data("board-opearator");
    var timestamp = jQuery(parent).data("board-day");

		if(action == "setVacation")
		{
			if(jQuery(parent).hasClass("vacation"))
			{
				jQuery(parent).removeClass("vacation");
        updateOperatorCalendar(operatorId, timestamp, 0);
			}
			else
			{
				// Andere Tagesmarkierungen entfernen
				jQuery(parent).removeClass("ill");
				jQuery(parent).removeClass("holiday");

				jQuery(parent).addClass("vacation");
        updateOperatorCalendar(operatorId, timestamp, 1);
			}

		}
		else if(action == "setIll")
		{
			if(jQuery(parent).hasClass("ill"))
			{
				jQuery(parent).removeClass("ill");
        updateOperatorCalendar(operatorId, timestamp, 0);
			}
			else
			{
				// Andere Tagesmarkierungen entfernen
				jQuery(parent).removeClass("vacation");
				jQuery(parent).removeClass("holiday");

				jQuery(parent).addClass("ill");
        updateOperatorCalendar(operatorId, timestamp, 2);
			}
		}



	});
});




function startCalendarDragAndDrop()
{
var itemContainers = [].slice.call(document.querySelectorAll('.board-column-content'));
var columnGrids = [];
var boardGrid;

// Define the column grids so we can drag those
// items around.
itemContainers.forEach(function (container) {

  // Instantiate column grid.
  var grid = new Muuri(container, {
    items: '.board-item',
    layoutDuration: 400,
    layoutEasing: 'ease',
    dragEnabled: true,
    dragSort: function () {
      return columnGrids;
    },
    dragSortInterval: 0,
    dragContainer: document.body,
    dragReleaseDuration: 400,
    dragReleaseEasing: 'ease'
  })
  .on('dragStart', function (item) {
    // Let's set fixed widht/height to the dragged item
    // so that it does not stretch unwillingly when
    // it's appended to the document body for the
    // duration of the drag.
    item.getElement().style.width = item.getWidth() + 'px';
    item.getElement().style.height = item.getHeight() + 'px';
  })
  .on('dragReleaseEnd', function (item) {

	//console.log(item); // item._child
	//console.log(item._id+" verschoben nach " +item._gridId );
	//console.log(item._child); // item._child
	var tag = jQuery(item._child).parents(".board-column");

  var boardDay = jQuery(tag).data("board-day");
  var boardOperator = jQuery(tag).data("board-operator");
  var boardAppointment = jQuery(item._child).parents(".board-item").data("board-appointment");

  //console.log(item);
  //console.log(item._child);
  //console.log("#"+boardAppointment + " verschoben nach " + boardDay);

  dragAppointmentToNewDate(boardAppointment, boardOperator, boardDay);

	//var tagCaption = jQuery(tag).find(".board-column-header").text();
	//var auftragCaption = jQuery(item._child).find("span").html();
	//console.log(item);
	//console.log(auftragCaption + " verschoben nach " + tagCaption);



    // Let's remove the fixed width/height from the
    // dragged item now that it is back in a grid
    // column and can freely adjust to it's
    // surroundings.
    item.getElement().style.width = '';
    item.getElement().style.height = '';
    // Just in case, let's refresh the dimensions of all items
    // in case dragging the item caused some other items to
    // be different size.
    columnGrids.forEach(function (grid) {
      grid.refreshItems();
    });
  })
  .on('layoutStart', function () {
    // Let's keep the board grid up to date with the
    // dimensions changes of column grids.
    boardGrid.refreshItems().layout();
  });

  // Add the column grid reference to the column grids
  // array, so we can access it later on.
  columnGrids.push(grid);

});

  // Instantiate the board grid so we can drag those
  // columns around.
  boardGrid = new Muuri('.board', {
    layoutDuration: 400,
    layoutEasing: 'ease',
    dragEnabled: true,
    dragSortInterval: 0,
    dragStartPredicate: {
      handle: '.board-column-header'
    },
    dragReleaseDuration: 400,
    dragReleaseEasing: 'ease'
  });
}



// Termin aus Sammelkalender auswählen
jQuery(document)
.on("click", ".dayEmpty[data-select-day], .dayAppointments[data-select-day]", function() {

  var datum = jQuery(this).data("select-day");
  var operatorId = jQuery(this).data("select-operator");
  var operatorName = jQuery(this).data("select-operatorname"); // Zum Vorblenden in Liste

  let callback = jQuery(".calendar_area_summary").data("callback");
  if (callback != '')
  {
    let parameters = [];
    parameters.operatorid = operatorId;
    parameters.dateAppointment = datum;
    parameters.operatorName = operatorName;
    callFunctionByString(callback, parameters);
  }
});


jQuery(document)
    .on("click", ".calendarheader.timelineheader i", function() {
      // TODO anderen Ladescreen oder Spinner anzeigen
      //jQuery(ajaxloader).fadeIn();
      var parent = jQuery(this).parents(".calendarheader");
      var currentMonth =  jQuery(parent).data("calendar-month");
      var currentYear =  jQuery(parent).data("calendar-year");
      var clientId =  jQuery(parent).data("calendar-client");

      var action = jQuery(this).data("action");

      var requestMonth = currentMonth;
      var requestYear = currentYear;
      if(action == "previous")
      {
        if(currentMonth == 1)
        {
          requestMonth = 12;
          requestYear = currentYear - 1;
        }
        else {
          requestMonth = currentMonth - 1;
        }
      }
      else if(action == "next")
      {
        if(currentMonth == 12)
        {
          requestMonth = 1;
          requestYear = currentYear + 1;
        }
        else {
          requestMonth = currentMonth + 1;
        }
      }

      jQuery.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]')
                  .attr('content')
          }
      });

      // Request new Calendar
      jQuery.ajax({
          method: 'GET',
          url: '/operator/calendar/requestCalendarSummary',
          data: {
              'month': requestMonth,
              'year': requestYear,
              'client_id': clientId,
              'callback': jQuery(".calendar_area_summary").data("callback")
          },
          success: function(response) {
              jQuery(".calendar_area_summary").replaceWith(response.html);

              specialResize();
          },
          error: function(jqXHR, textStatus, errorThrown) {
              console.log(JSON.stringify(jqXHR));
              console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
              // TODO anderen Ladescreen oder Spinner anzeigen
              //jQuery(ajaxloader).fadeOut("slow");
          }
      });
});
