'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var CustomizedDropzone = function CustomizedDropzone(dropzoneContainer, options, relatedForm) {
    _classCallCheck(this, CustomizedDropzone);

    var dropzoneDefaultOptions = {
        // Bildnamen zufällig setzen
        renameFilename: function renameFilename(file) {
            var newName = 'tmp_' + new Date().getTime() + '_' + guid() + file;
            return newName;
        },

        init: function init() {
            var dropzone = this;

            // Preview-Bereich vorerst ausblenden
            jQuery(dropzoneContainer + " .filePreview").hide();

            // Vorschaubild entfernen, Dropzone zurücksetzen, wenn temporäres Bild wieder entfernt wird
            jQuery(dropzoneContainer + " .removePreviewFile").click(function () {
                dropzone.removeAllFiles();
                jQuery(dropzoneContainer + " .filePreview").hide();
                jQuery(dropzoneContainer + " .dropUpload").fadeIn();
                jQuery(dropzoneContainer + " .existingFile").fadeIn();
                jQuery(relatedForm + " input[name=deleteFile]").val("0");
                jQuery(relatedForm + " input[name='newFile']").val("");
            });

            jQuery(dropzoneContainer + " .removeExistingFile > span > i").click(function () {
                // Flag setzen
                jQuery(relatedForm + " input[name=deleteFile]").val("1");

                // Bildcontainer ausblenden
                jQuery(dropzoneContainer + " .existingFile").hide();

                // DropzoneController aktivieren
                var dropzoneStyles = {
                    height: "unset"
                };

                var uploadContainerStyles = {
                    opacity: "1"
                };

                jQuery(dropzoneContainer + " .dropzone").css(dropzoneStyles);
                jQuery(dropzoneContainer + " .uploadContainer").css(uploadContainerStyles);
            });
        }
    };

    // Individuelle Optionen hinzufügen
    jQuery.extend(dropzoneDefaultOptions, options);

    // DropzoneController instanziieren
    this.dropzone = new Dropzone(dropzoneContainer, dropzoneDefaultOptions);

    // Wenn mehr als ein Bild gedraggt wird oder mehrere hintereinander reingezogen werden,
    // lösche alle Bilder und füge nur das letzte (=aktuellste) hinzu
    this.dropzone.on("maxfilesexceeded", function (file) {
        this.removeAllFiles(true);
        this.disable();
        this.enable();
        this.addFile(file);
    });

    // User zieht Bild in den D&D-Bereich oder fuegt es ueber "Durchsuchen" hinzu
    this.dropzone.on("addedfile", function (file) {
        // Flag setzen
        jQuery(relatedForm + " input[name=deleteFile]").val("1");

        // Uploadcontainer einblenden (mobile)
        jQuery(dropzoneContainer + " .uploadContainer").show();

        jQuery(dropzoneContainer + " .dropUpload").hide();

        // Preview-Bereich einblenden
        jQuery(dropzoneContainer + " .filePreview").fadeIn(800);
        jQuery(dropzoneContainer + " .existingFile").hide();
    });

    // Bei erfolgreichem Upload Bildnamen in Input-Feld merken
    this.dropzone.on("success", function (file) {
        jQuery(relatedForm + " input[name='newFile']").val(file.upload.filename);
    });


    this.dropzone.on("error", function (file, errorMessage) {

        // File überprüfen, um Fehler zu bestimmen
        // Zu groß?
        if (file.size > dropzoneDefaultOptions["maxFilesize"] * 1000000) {
            // Alle Dateien entfernen, von vorne
            this.removeAllFiles();
            jQuery(dropzoneContainer + " .filePreview").hide();
            jQuery(dropzoneContainer + " .dropUpload").fadeIn();
            jQuery(dropzoneContainer + " .existingFile").fadeIn();
            showModalBox("Fehler", errorMessage);

            // Flags zurücksetzen
            jQuery(relatedForm + " input[name=deleteFile]").val("0");
        }

        // Falscher Dateityp?
        var allowedFileTypes = dropzoneDefaultOptions.acceptedFiles.split(",");
        if (allowedFileTypes.indexOf(file.type) < 0) {
            // Alle Dateien entfernen, von vorne
            this.removeAllFiles();
            jQuery(dropzoneContainer + " .filePreview").hide();
            jQuery(dropzoneContainer + " .dropUpload").fadeIn();
            jQuery(dropzoneContainer + " .existingFile").fadeIn();
            showModalBox("Fehler", errorMessage);

            // Flags zurücksetzen
            jQuery(relatedForm + " input[name=deleteFile]").val("0");
        }

        // Zu viele Dateien werden im Event "maxfilesexceeded" abgefangen.
    });
};

var CustomizedDropzoneMulti = function CustomizedDropzoneMulti(dropzoneContainer, options, relatedForm) {
    _classCallCheck(this, CustomizedDropzoneMulti);

    var dropzoneDefaultOptions = {
        // Bildnamen zufällig
        renameFilename: function renameFilename(file) {
            var newName = 'tmp_' + guid() + file;
            return newName;
        },

        init: function init() {
            var dropzone = this;
            // Preview-Bereich vorerst ausblenden
            jQuery(".imagePreview").hide();
        },

        // Dropzone-Thumbnails für Dateitypen, die nicht Bild sind
        accept: function accept(file, done) {
            var thumbnailImg = $('.dropzone .dz-preview.dz-file-preview .dz-image:last img');
            var icon = "thumbnail_file.png";

            switch (file.type) {
                // PDF
                case 'application/pdf':
                    icon = "thumbnail_pdf.png";
                    break;

                // Microsoft Word
                case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
                case 'application/vnd.openxmlformats-officedocument.wordprocessingml.template':
                case 'application/msword':
                    icon = "thumbnail_word.png";
                    break;

                // Microsoft Powerpoint
                case 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
                case 'application/vnd.openxmlformats-officedocument.presentationml.slide':
                case 'application/vnd.openxmlformats-officedocument.presentationml.slideshow':
                case 'application/vnd.ms-powerpoint':
                    icon = "thumbnail_powerpoint.png";
                    break;

                // Microsoft Excel
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.template':
                case 'application/vnd.ms-excel':
                    icon = "thumbnail_excel.png";
                    break;
                default:
                    icon = "thumbnail_file.png";
            }

            thumbnailImg.attr("src", "../images/fileIcons/" + icon);
            thumbnailImg.css("height", "90px");
            done();
        }
    };

    // Individuelle Optionen hinzufügen
    jQuery.extend(dropzoneDefaultOptions, options);

    // DropzoneController instanziieren
    this.dropzone = new Dropzone(dropzoneContainer, dropzoneDefaultOptions);

    // Bei Entfernen eines (Vorschau)Bildes merken, welches Bild entfernt wurde, damit es im Nachhinein auch vom
    // Server wieder gelöscht bzw. nicht zugeordnet werden kann
    this.dropzone.on("removedfile", function (file) {
        var _newFiles = jQuery(relatedForm + " input[name='" + options.dropzoneName + "']");
        var value_newFiles = _newFiles.val();
        var json_newFiles = JSON.parse(value_newFiles);

        var index = json_newFiles["files"].indexOf(file.upload.filename);
        if (index > -1) {
            json_newFiles["files"].splice(index, 1);
        }

        var newValue_newFiles = JSON.stringify(json_newFiles);
        _newFiles.val(newValue_newFiles);
    });

    // User zieht Bild in den D&D-Bereich oder fuegt es ueber "Durchsuchen" hinzu
    this.dropzone.on("addedfile", function (file) {
        // D&D-Bereich ausblenden
        jQuery(dropzoneContainer + " .dropUpload").hide();
    });

    // Bei erfolgreichem Upload Bildname merken
    this.dropzone.on("success", function (file) {
        var _newFiles = jQuery(relatedForm + " input[name='" + options.dropzoneName + "']");

        var value_newFiles = _newFiles.val();
        var json_newFiles = JSON.parse(value_newFiles);

        json_newFiles["files"].push(file.upload.filename);
        json_newFiles["fileSizes"].push(file.size);

        var newValue_newFiles = JSON.stringify(json_newFiles);
        _newFiles.val(newValue_newFiles);
    });

    // Handling, wenn mehr Bilder hochgeladen werden als erlaubt
    this.dropzone.on("maxfilesexceeded", function (file) {
        showModalBox("Fehler", dropzoneDefaultOptions["dictMaxFilesExceeded"]);
        this.removeFile(file);
    });

    // Errorhandling für weitere Fehler
    this.dropzone.on("error", function (file, errorMessage) {

        // File überprüfen, um Fehler zu bestimmen
        // Zu groß?
        if (file.size > dropzoneDefaultOptions["maxFilesize"] * 1000000) {
            this.removeFile(file);
            showModalBox("Fehler", errorMessage);
        }

        // Falscher Dateityp?
        var allowedFileTypes = dropzoneDefaultOptions.acceptedFiles.split(",");
        if (allowedFileTypes.indexOf(file.type) < 0) {
            this.removeFile(file);
            showModalBox("Fehler", errorMessage);
        }

        // Zu viele Dateien werden im Event "maxfilesexceeded" abgefangen.
    });
};
