@extends('layouts.masterOutside')

@section('content')
    <main class="contentContainer">

        @if (count($errors) <= 0)
            <h1>{{ $client->name }}: Administrator registrieren</h1>


            <p>Zuerst muss für <strong>{{ $client->name }}</strong> ein Administrator-User angelegt werden.</p>

            <p>&nbsp;</p>

            {!!BootForm::open(["id" => "registerFirstClientAdmin",
                               "route" => array('client.registerFirstClientAdmin'),
                               "method" => "POST"
                               ])!!}

            <div class="row">
                <div class="col-md-10 offset-1">

                    <div class="form-group row">
                        <label for="clientAdminName" class="col-sm-4 col-form-label">Nachname</label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="name">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="clientAdminFirstname" class="col-sm-4 col-form-label">Vorname</label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="firstname">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="clientAdminEMail" class="col-sm-4 col-form-label">E-Mail</label>
                        <div class="col-sm-8">
                            <input type="email" class="form-control" name="email">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="clientAdminPassword" class="col-sm-4 col-form-label">Passwort</label>
                        <div class="col-sm-8">
                            <input type="password" class="form-control" name="password">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="clientAdminPasswordConfirm" class="col-sm-4 col-form-label">Passwort
                            bestätigen</label>
                        <div class="col-sm-8">
                            <input type="password" class="form-control" name="password_confirmation">
                        </div>
                    </div>

                    <input type="hidden" name="clientToken" value="{{ $token }}">

                    <div class="form-group row mb-0">
                        <div class="col-md-8 offset-md-4 text-md-right">
                            <button type="submit" class="btn btn-primary btn-big">
                                Registrieren
                            </button>
                        </div>
                    </div>
                </div>
            </div>


            {!! BootForm::close() !!}
        @endif
    </main>
@endsection
