<?php
$username = $userToEdit->firstname . " " . $userToEdit->name;
?>

{!!BootForm::open(["id" => "deleteUser",
                   "route" => array('clientAdmin.deleteUser'),
                   "method" => "POST",
                   "enctype" => "multipart/form-data"])!!}
<input type="hidden" name="userToEdit" value="{{ $userToEdit->id }}">

<div>
    <header>Benutzer löschen: {{ $username }}</header>

    <div class="container">

        <div class="row">
            <div class="col-md-12">
                <p>Bist du dir sicher, dass du den Benutzer <strong>{{ $username }}</strong> löschen möchtest?</p>
            </div>
        </div>


        <div class="row align-items-center">
            <div class="col-md-10">
                Bitte bestätige das Löschen, indem du die Checkbox aktivierst.
                <input type="hidden" name="userToEdit" value="{{ $userToEdit->id }}">
            </div>

            <div class="col-md-2">
                <label class="toggleCheckbox">
                    <input type="checkbox" name="confirmDelete">
                    <i class="bigger"></i>
                </label>
            </div>
        </div>


        <div class="alert alert-danger">
            <div class="alertIcon">
                <i class="far fa-exclamation-circle"></i>
            </div>
            <div>
                Diese Aktion kann nicht rückgängig gemacht werden.
            </div>
        </div>
    </div>
</div>



<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" class="btn btn-primary">
                Benutzer {{ $username }} löschen
            </button>
        </div>
    </div>
</footer>


<script>
    // Abbrechen-Button
    // Muss hier extra deklariert werden, weil dieses Template asynchron via Ajax ausgeliefert wird und der DOM bereits
    // aufgebaut und geladen ist
    jQuery("#closeUserListEditorButton").click(function () {
        jQuery("#closeUserListEditor").trigger("click");
    });
</script>

{!!BootForm::close()!!}