@extends('layouts.master')
<?php
use App\Operator;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\UserController;
use Carbon\Carbon;
use App\User;
use App\Customer;
use App\OrderStatus;

$c = Carbon::now();
$currentMonth = $c->month;
$currentYear = $c->year;

$loggedUser = User::find(Auth::user()->id);
$customers = Customer::where("client_id", $loggedUser->client->id)->get();
$orderstates = OrderStatus::get();
$operators = Operator::orderby('name')->get();

$monthsDe = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
$results = DB::select('select year(max(end_date)) as yearmax, year(min(end_date)) as yearmin from orders where client_id = :client_id', ['client_id' => $loggedUser->client->id]);
?>

@section('content')
  <main class="contentContainer">

    <script type="text/javascript" src="../js/bootstrap-datetimepicker.js" charset="UTF-8"></script>
    <script type="text/javascript" src="../js/bootstrap-datetimepicker.de.js" charset="UTF-8"></script>

    <h1>Exportfunktion</h1>

    @if(sizeof($results)==1)
      @php
        $minyear = $results[0]->yearmin;
        $maxyear = $results[0]->yearmax;
      @endphp
      <h2>Export nach Kunde</h2>
      <div data-container="controlling-export" class="controllingExportContainer">
        <div class="row listHeader">
          <div class="col-4">Kunde</div>
          <div class="col-4 text-center">von</div>
          <div class="col-4 text-center">bis</div>
        </div>
        <div class="row mt-3">
          <div class="col-4">
            <select class="form-control" name="customer">
            @foreach ($customers as $customer)
              <option value="{{$customer->id}}">{{$customer->company}}</option>
            @endforeach
            </select>
          </div>
          <div class="col-2">
            <select class="form-control" name="month_from">
            @foreach ($monthsDe as $i => $month)
              <option value="{{$i+1}}" {{($i+1 == $currentMonth)?"selected":""}}>{{$month}}</option>
            @endforeach
            </select>
          </div>
          <div class="col-2">
            <select class="form-control" name="year_from">
            @for($year=$minyear;$year<=$maxyear;$year++)
              <option value="{{$year}}" {{($year == $currentYear)?"selected":""}}>{{$year}}</option>
            @endfor
            </select>
          </div>
          <div class="col-2">
            <select class="form-control" name="month_to">
              @foreach ($monthsDe as $i => $month)
                <option value="{{$i+1}}"  {{($i+1 == $currentMonth)?"selected":""}}>{{$month}}</option>
              @endforeach
            </select>
          </div>
          <div class="col-2">
            <select class="form-control" name="year_to">
            @for($year=$minyear;$year<=$maxyear;$year++)
              <option value="{{$year}}" {{($year == $currentYear)?"selected":""}}>{{$year}}</option>
            @endfor
            </select>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 text-right">
            <button data-action="controlling-export" class="btn btn-primary btn-big">
            Export erstellen
            </button>
          </div>
        </div>
      </div>
      <h2>Export nach Auftragsstatus</h2>
      <div data-container="controlling-export" class="controllingExportContainer">
        <div class="row listHeader">
          <div class="col-4">Auftragsstatus</div>
          <div class="col-4 text-center">von</div>
          <div class="col-4 text-center">bis</div>
        </div>
        <div class="row mt-3">
          <div class="col-4">
            <select class="form-control" name="orderstate">
              @foreach ($orderstates as $orderstate)
                <option value="{{$orderstate->id}}">{{$orderstate->label}}</option>
              @endforeach
            </select>
          </div>
          <div class="col-4">
            <div class="form-group">
              <div class="input-group date form_date" data-date="" data-date-format="dd.mm.yyyy" data-link-field="dtp_input2" data-link-format="Y-m-d">
                <input class="form-control" type="text" value="" readonly name="date_from_orderstate">
                <span class="input-group-addon"><i class="far fa-times"></i></span>
                <span class="input-group-addon"><i class="far fa-calendar"></i></span>
              </div>
              <input type="hidden" id="dtp_input2" value="" /><br/>
            </div>
          </div>
          <div class="col-4">
            <div class="form-group">
              <div class="input-group date form_date" data-date="" data-date-format="dd.mm.yyyy" data-link-field="dtp_input2" data-link-format="Y-m-d">
                <input class="form-control" type="text" value="" readonly name="date_to_orderstate">
                <span class="input-group-addon"><i class="far fa-times"></i></span>
                <span class="input-group-addon"><i class="far fa-calendar"></i></span>
              </div>
              <input type="hidden" id="dtp_input2" value="" /><br/>
            </div>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 text-right">
            <button data-action="controlling-export_orderstate" class="btn btn-primary btn-big">
              Export erstellen
            </button>
          </div>
        </div>
      </div>
      <h2>Export nach Mitarbeiter/Subunternehmer</h2>
      <div data-container="controlling-export" class="controllingExportContainer">
        <div class="row listHeader">
          <div class="col-4">Mitarbeiter/Subunternehmer</div>
          <div class="col-4 text-center">von</div>
          <div class="col-4 text-center">bis</div>
        </div>
        <div class="row mt-3">
          <div class="col-4">
            <select class="form-control" name="operator">
              @foreach ($operators as $operator)
                <option value="{{$operator->id}}">{{$operator->name.' '.$operator->firstname.' '.($operator->company!=null?'('.$operator->company.')':'')}}</option>
              @endforeach
            </select>
          </div>
          <div class="col-4">
            <div class="form-group">
              <div class="input-group date form_date" data-date="" data-date-format="dd.mm.yyyy" data-link-field="dtp_input2" data-link-format="Y-m-d">
                <input class="form-control" type="text" value="" readonly name="date_from_operator">
                <span class="input-group-addon"><i class="far fa-times"></i></span>
                <span class="input-group-addon"><i class="far fa-calendar"></i></span>
              </div>
              <input type="hidden" id="dtp_input2" value="" /><br/>
            </div>
          </div>
          <div class="col-4">
            <div class="form-group">
              <div class="input-group date form_date" data-date="" data-date-format="dd.mm.yyyy" data-link-field="dtp_input2" data-link-format="Y-m-d">
                <input class="form-control" type="text" value="" readonly name="date_to_operator">
                <span class="input-group-addon"><i class="far fa-times"></i></span>
                <span class="input-group-addon"><i class="far fa-calendar"></i></span>
              </div>
              <input type="hidden" id="dtp_input2" value="" /><br/>
            </div>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 text-right">
            <button data-action="controlling-export_operator" class="btn btn-primary btn-big">
              Export erstellen
            </button>
          </div>
        </div>
      </div>
      <h2>Export nach Gutschriften</h2>
      <div data-container="controlling-export">
        <div class="row listHeader">
          <div class="col-4"></div>
          <div class="col-4 text-center">von</div>
          <div class="col-4 text-center">bis</div>
        </div>
        <div class="row mt-3">
          <div class="col-4">
          </div>
          <div class="col-4">
            <div class="form-group">
              <div class="input-group date form_date" data-date="" data-date-format="dd.mm.yyyy" data-link-field="dtp_input2" data-link-format="Y-m-d">
                <input class="form-control" type="text" value="" readonly name="date_from_credit">
                <span class="input-group-addon"><i class="far fa-times"></i></span>
                <span class="input-group-addon"><i class="far fa-calendar"></i></span>
              </div>
              <input type="hidden" id="dtp_input2" value="" /><br/>
            </div>
          </div>
          <div class="col-4">
            <div class="form-group">
              <div class="input-group date form_date" data-date="" data-date-format="dd.mm.yyyy" data-link-field="dtp_input2" data-link-format="Y-m-d">
                <input class="form-control" type="text" value="" readonly name="date_to_credit">
                <span class="input-group-addon"><i class="far fa-times"></i></span>
                <span class="input-group-addon"><i class="far fa-calendar"></i></span>
              </div>
              <input type="hidden" id="dtp_input2" value="" /><br/>
            </div>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 text-right">
            <button data-action="controlling-export_credit" class="btn btn-primary btn-big">
              Export erstellen
            </button>
          </div>
        </div>
      </div>
      <script type="text/javascript">
        $('.form_date').datetimepicker({
          language:  'de',
          weekStart: 1,
          todayBtn:  1,
          autoclose: 1,
          todayHighlight: 1,
          startView: 2,
          minView: 2,
          forceParse: 0,
          initialDate: new Date()
        });

        $('.form_date').datetimepicker("setDate", new Date());

      </script>
      <script>
        jQuery(document).on("click", "[data-action]", function() {
          let action = jQuery(this).data("action");
          let me = jQuery(this);
          if(action=="controlling-export")
          {
            let parent = me.parents("[data-container=controlling-export]");
            let customerId = parent.find("[name=customer]").val();
            let monthFrom = parent.find("[name=month_from]").val();
            let monthTo = parent.find("[name=month_to]").val();
            let yearFrom = parent.find("[name=year_from]").val();
            let yearTo = parent.find("[name=year_to]").val();

            let link="/controlling/export/"+customerId+"/"+monthFrom+"-"+yearFrom+"/"+monthTo+"-"+yearTo;
            window.open(
              link, '_blank'
            );
          }
          else if(action=="controlling-export_orderstate")
          {
            let parent = me.parents("[data-container=controlling-export]");
            let orderstateId = parent.find("[name=orderstate]").val();
            let dateFrom = parent.find("[name=date_from_orderstate]").val();
            let dateTo = parent.find("[name=date_to_orderstate]").val();

            let link="/controlling/exportOrderstate/"+orderstateId+"/"+dateFrom+"/"+dateTo;
            window.open(
                    link, '_blank'
            );
          }
          else if(action=="controlling-export_operator")
          {
            let parent = me.parents("[data-container=controlling-export]");
            let operatorId = parent.find("[name=operator]").val();
            let dateFrom = parent.find("[name=date_from_operator]").val();
            let dateTo = parent.find("[name=date_to_operator]").val();

            let link="/controlling/exportOperator/"+operatorId+"/"+dateFrom+"/"+dateTo;
            window.open(
                    link, '_blank'
            );
          }
          else if(action=="controlling-export_credit")
          {
            let parent = me.parents("[data-container=controlling-export]");
            let dateFrom = parent.find("[name=date_from_credit]").val();
            let dateTo = parent.find("[name=date_to_credit]").val();

            let link="/controlling/exportCredit/"+dateFrom+"/"+dateTo;
            window.open(
                    link, '_blank'
            );
          }
        });
      </script>
    @else
      Es sind noch keine abgeschlossenen Aufträge vorhanden
    @endif

  </main>
@endsection
