@extends('layouts.siteResourceheader')

@section('body')
    <header>
        @include('layouts.nav')
    </header>
    <div class="alertContainer">
        @if (count($errors) > 0)
            <div class="alert alert-danger">
                <div class="alertIcon">
                    <i class="far fa-exclamation-circle"></i>
                </div>
                <div>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif

        @if (session('message'))
            <div class="alert alert-info">
                <div class="alertIcon">
                    <i class="far fa-info-circle"></i>
                </div>
                <div>
                    {{ session('message') }}
                </div>
            </div>
        @endif

        @if (session('okayWithErrors'))
            <div class="alert alert-warning">
                <div class="alertIcon">
                    <i class="far fa-meh"></i>
                </div>
                <div>
                    {{ session('okayWithErrors') }}
                </div>
            </div>
        @endif

        @if (session('status'))
            <div class="alert alert-info">
                <div class="alertIcon">
                    <i class="far fa-info-circle"></i>
                </div>
                <div>
                    {{ session('status') }}
                </div>
            </div>
        @endif

    </div>


    <div class="baseContainer">
        @yield('content')
    </div>

    <footer>
        Projektverwaltung - KTK-Mouldtec GmbH
    </footer>
<script>

    $(document).ready(function() {
        setTimeout(checkMessage, 1000);
    });

    function checkMessage()
    {
        $.get("/checkMessages", function(data, status) {
            if(data == "{}")
            {
                setTimeout(checkMessage, 1000);
            }
            else
            {
                jsonData = JSON.parse(data);

                Swal.fire({
                    position: 'bottom-end',
                    icon: jsonData.message_type,
                    title: jsonData.title,
                    html: jsonData.subtitle,
                    showConfirmButton: false,
                    // timerProgressBar: true,
                    // timer: 10000
                    // confirmButtonText: "Okay",
                    showCloseButton: true
                });

                // debugger;
                setTimeout(checkMessage, 5000);
            }
        });

    }

</script>
@endsection