<?php

use App\Http\Controllers\UserController;

$followUpsToday = $user->operator->followUpsTempus();
$followUpsTodayCnt = count($followUpsToday);

// Logo
$path = "/images/ktkmouldtec_logo.png";
?>
<nav class="navbar navbar-expand-lg navbar-light">
    <a class="navbar-brand" href="{{ route('index') }}"><img src="{{ $path }}" alt=""
                                                             style="width:80px;"></a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <i class="fas fa-bars"></i>
    </button>

    <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
            @if(UserController::checkRight("seeOrdersList", $user))
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('projects.list') }}">
                        Projekte
                    </a>
                </li>
            @endif
            @if(UserController::checkRight("seeCustomersList", $user))
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('customer.list') }}">
                        Kunden
                    </a>
                </li>
            @endif
{{--            @if(UserController::checkRight("seeCustomersList", $user))--}}
{{--                <li class="nav-item">--}}
{{--                    <a class="nav-link" href="{{ route('customer.list') }}">--}}
{{--                        Artikeldaten--}}
{{--                    </a>--}}
{{--                </li>--}}
{{--            @endif--}}
            @if(UserController::checkRight("seeCustomersList", $user))
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('operatinginstructions.list') }}">
                        Arbeitsanweisungen
                    </a>
                </li>
            @endif
            @if(UserController::checkRight("seeCustomersList", $user))
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('proceduralinstructions.list') }}">
                        Verfahrensanweisungen
                    </a>
                </li>
            @endif


            @if(UserController::hasAnyConfigurationRights($user))
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown"
                       aria-haspopup="true" aria-expanded="false">
                        Konfiguration
                    </a>
                    <div class="dropdown-menu">

                        @if(UserController::hasAnyGeneralConfigurationRights($user))
                            <p class="dropdown-header">Stammdaten</p>
{{--                            @if(UserController::checkRight("seeNumberRanges", $user))--}}
{{--                                <a class="dropdown-item" href="{{ route('numberRanges.list') }}">Nummernkreise--}}
{{--                                    verwalten</a>--}}
{{--                            @endif--}}
                            @if(UserController::checkRight("seeOperatorList", $user))
{{--                                <li class="nav-item">--}}
                                    <a class="dropdown-item" href="{{ route('operator.list') }}">
                                        Bearbeiter
                                    </a>
{{--                                </li>--}}
                            @endif
                            <div class="dropdown-divider"></div>
                        @endif

                        @if(UserController::hasAnyOrderConfigurationRights($user))
                            <p class="dropdown-header">Projekte</p>
                            @if(UserController::checkRight("seeOrderTypes", $user))
                                <a class="dropdown-item" href="{{ route('projectTypes.list') }}">Projekttypen
                                    verwalten</a>
                                    <a class="dropdown-item" href="{{ route('articleVariables.list') }}">Artikelvariablen verwalten</a>
                                    <a class="dropdown-item" href="{{ route('projectVariables.list') }}">Projektvariablen verwalten</a>
                            @endif
{{--                            @if(UserController::checkRight("seeOrderTags", $user))--}}
{{--                                <a class="dropdown-item" href="{{ route('orderTags.list') }}">Auftragskennzeichen--}}
{{--                                    verwalten</a>--}}
{{--                            @endif--}}
{{--                            @if(UserController::checkRight("seeOrderStatus", $user))--}}
{{--                                <a class="dropdown-item" href="{{ route('orderStatus.list') }}">Auftragsstatus--}}
{{--                                    verwalten</a>--}}
{{--                            @endif--}}
{{--                            @if(UserController::checkRight("seeOrderPaymentStatus", $user))--}}
{{--                                <a class="dropdown-item" href="{{ route('orderPaymentStatus.list') }}">Bezahlstatus--}}
{{--                                    verwalten</a>--}}
{{--                            @endif--}}
{{--                            <div class="dropdown-divider"></div>--}}
                        @endif
{{--                        @if(UserController::hasAnyProductConfigurationRights($user))--}}
{{--                            <p class="dropdown-header">Artikel/Dienstleistungen</p>--}}
{{--                            @if(UserController::checkRight("seeProducts", $user))--}}
{{--                                <a class="dropdown-item" href="{{ route('products.list') }}">Artikel verwalten</a>--}}
{{--                            @endif--}}
{{--                            <div class="dropdown-divider"></div>--}}
{{--                        @endif--}}
{{--                        @if(UserController::hasAnyMailConfigurationRights($user))--}}
{{--                            <p class="dropdown-header">E-Mails</p>--}}
{{--                            @if(UserController::checkRight("seeTextblocks", $user))--}}
{{--                                <a class="dropdown-item" href="{{ route('textblocks.list') }}">Textbausteine--}}
{{--                                    verwalten</a>--}}
{{--                            @endif--}}
{{--                        @endif--}}
                    </div>
                </li>
            @endif

{{--            @if(UserController::checkRight("seeControlling", $user))--}}
{{--                <li class="nav-item dropdown">--}}
{{--                    <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown"--}}
{{--                       aria-haspopup="true" aria-expanded="false">--}}
{{--                        Controlling--}}
{{--                    </a>--}}
{{--                    <div class="dropdown-menu">--}}
{{--                        <a class="dropdown-item" href="{{ route('controlling.list') }}">Gesamtübersicht</a>--}}
{{--                        <a class="dropdown-item" href="{{ route('controlling.monthlyList') }}">Monatsübersicht</a>--}}
{{--                        <a class="dropdown-item" href="{{ route('controlling.export') }}">Exportfunktion</a>--}}
{{--                    </div>--}}
{{--                </li>--}}
{{--            @endif--}}

            @if(UserController::isClientAdmin($user))
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarAdmin" role="button"
                       data-toggle="dropdown"
                       aria-haspopup="true" aria-expanded="false">
                        Administrator
                    </a>
                    <div class="dropdown-menu" aria-labelledby="navbarAdmin">
                        <p class="dropdown-header">Mandantenverwaltung</p>
                        @if(UserController::isSuperAdmin($user))
                            <a class="dropdown-item" href="{{ route('superAdmin.newClient') }}">Neuen Mandanten
                                anlegen</a>
                        @endif
                        <a class="dropdown-item" href="{{ route('client.edit') }}">Stammdaten bearbeiten</a>
                        <div class="dropdown-divider"></div>
                        <p class="dropdown-header">User</p>
                        <a class="dropdown-item" href="{{ route('clientAdmin.newUser') }}">User anlegen</a>
                        <a class="dropdown-item" href="{{ route('clientAdmin.users') }}">Alle anzeigen</a>
                    </div>
                </li>
            @endif

        </ul>

        <div class="divider-horizontal d-lg-none"></div>


        <ul class="navbar-nav mr-right">

            <li class="nav-icon">
                <a href="{{ route('user.edit') }}"><i class="fal fa-cog d-none d-lg-block"></i> <span class="d-lg-none">Einstellungen</span></a>
            </li>
{{--            @if(UserController::checkRight("seeOrdersList", $user))--}}
{{--                <li class="nav-icon">--}}
{{--                    <a href="{{ route('orderFollowUp.list') }}">--}}
{{--                        @if($followUpsTodayCnt > 0)--}}
{{--                            <i class="fas fa-bell d-none d-lg-block" id="followUpsBell"></i>--}}
{{--                            <div id="followUpsTodayCnt">{{ $followUpsTodayCnt }} Wiedervorlage(n)</div>--}}
{{--                        @else--}}
{{--                            <i class="fal fa-bell d-none d-lg-block"></i>--}}
{{--                        @endif--}}
{{--                        <span class="d-lg-none">Benachrichtigungen</span></a>--}}
{{--                </li>--}}
{{--            @endif--}}
            <li class="nav-icon">
                <a class="" href="{{ route('logout') }}"
                   onclick="event.preventDefault();
                   document.getElementById('logout-form').submit();">
                    <i class="fal fa-sign-out d-none d-lg-block"></i> <span class="d-lg-none">Logout</span>
                </a>

                <form id="logout-form" action="{{ route('logout') }}" method="POST"
                      style="display: none;">
                    @csrf
                </form>
            </li>
        </ul>

        <div class="divider-horizontal d-lg-none"></div>

        <div class="d-lg-none">
            <div class="userName">
                Eingeloggt als <strong>{{ $user->getName() }}</strong>
            </div>
        </div>


    </div>
    <div class="divider-vertical d-none d-lg-block"></div>

    <div class="nav-user-img" style="background-image: url('{{ $user->getImage() }}');">
    </div>

    <ul class="navbar-nav openUserNavCard">
        <li class="nav-item dropdown nav-user">
            <a class="nav-link dropdown-toggle" href="#" id="navbarUsercard" role="button" data-toggle="dropdown"
               aria-haspopup="true" aria-expanded="false">
                {{  $user->getName() }}
            </a>
            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarUsercard">
                <div class="dropdown-item userNavCard">

                    <div class="row">
                        <div class="col-3">
                            <div class="navCard-user-img"
                                 style="background-image: url('{{ $user->getImage() }}');"></div>
                        </div>
                        <div class="col-9 p-0">
                            <div class="userName">
                                {{ $user->getName() }}
                            </div>
                            <div class="userEmail">
                                {{ $user->email }}
                            </div>
                            <div>
                                <a href="{{ route('user.edit') }}">Profil & Einstellungen</a>
                            </div>
                        </div>
                    </div>

                    <div class="divider-horizontal"></div>

                    <div class="row">
                        <div class="col-md-4">
                            <a class="dropdown-item userNavCardFooter" href="{{ route('logout') }}"
                               onclick="event.preventDefault();
                   document.getElementById('logout-form').submit();">
                                {{ __('Logout') }}
                            </a>

                            <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                  style="display: none;">
                                @csrf
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </li>
    </ul>

</nav>
