<?php

?>

<header>Nummernkreis bearbeiten: {{ $numberRange->key_label }}</header>


<div class="container">
    {!! BootForm::open(["id" => "editNumberRange",
                         "route" => array("numberRanges.update", $numberRange->id),
                         "method" => "POST",
                         "enctype" => "multipart/form-data"]);
                         !!}

    <div class="form-group row">
        <label for="current_number" class="col-12 col-lg-4 col-form-label">Aktueller Stand</label>
        <div class="col-12 col-lg-8">
            <input type="number" name="current_number" id="current_number"
                   class="form-control" value="{{ $numberRange->current_number }}">
        </div>
    </div>

    <div class="alert alert-danger">
        <div class="alertIcon">
            <i class="far fa-exclamation-circle"></i>
        </div>
        <div>
            Wenn der aktuelle Stand des Nummernkreises geändert wird, sind die {{ $numberRange->key_label }}n nicht mehr
            konsistent!
            Es kann zur doppelten Vergabe von Nummern kommen!
        </div>
    </div>
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editNumberRange" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

{!! BootForm::close() !!}


{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif

