<script>
    // Nutzerrechte für spätere Verwendung als JS-Variable parsen
    let canEditOrders = JSON.parse("{{ $canEditOrders }}");
    let canDeleteOrders = JSON.parse("{{ $canDeleteOrders }}");
    let canCreateOrders = JSON.parse("{{ $canCreateOrders }}");
    let hideSensibleOrderData = JSON.parse("{{ $hideSensibleOrderData }}");

    if (typeof entriesPerPage === "undefined")
        var entriesPerPage = 10;

    jQuery(function () {
        // Initiale Suche starten bei Neuladen der Seite
        startSearch(entriesPerPage, 0, canCreateOrders, canEditOrders, canDeleteOrders, 0, listType, hideSensibleOrderData);
    });

    // Bei Drücken der Enter-Taste suche starten
    //jQuery(document).on('focusout', 'div.filter-extended', function () {
    jQuery(document).on('keypress', 'body', function () {
        jQuery(".filter-extended[data-filtertype=customer]").find(".liveSearchResults").html("");

        var keycode = (event.keyCode ? event.keyCode : event.which);
        if (keycode != '13') {
            return;
        }

        startSearch(entriesPerPage, 0, canCreateOrders, canEditOrders, canDeleteOrders, 0, listType, hideSensibleOrderData);
    });

    // Bei Klick auf den Button starten
    jQuery(document).on('click', 'button#startSearch', function () {
        startSearch(entriesPerPage, 0, canCreateOrders, canEditOrders, canDeleteOrders, 0, listType, hideSensibleOrderData);
    });

    // Klick auf Paginierungs-Link
    jQuery(document).on('click', '.searchPagination a.page-link', function () {

        // Seitenzahl bestimmen
        let pageNumber = jQuery(this).data("pagenumber");

        // Klick auf Punkte in Paginierung wird ignoriert
        if (pageNumber == "-1") return;

        // Offset berechnen
        let offset = pageNumber * entriesPerPage;

        // Suche starten
        startSearch(entriesPerPage, offset, canCreateOrders, canEditOrders, canDeleteOrders, pageNumber, listType, hideSensibleOrderData);

        jQuery(".searchPagination li").removeClass("active");
    });


    // Bei Klick auf Auftraggebernamen Overlay öffnen
    jQuery(document).on('click', 'a.showCustomer', function () {
        showLoadingSpinner();

        let url = "/customer";
        let customer_id = jQuery(this).data("customerid");

        $.get(url + '/' + customer_id, function (data) {
            if (data.response == "success") {
                jQuery("#loadingSpinner").hide();
                jQuery("#editorContent").html(data.editorHTML);
                jQuery("#listEditor").addClass("windowWide");
                jQuery("#listEditor").fadeIn();
            } else {
                error = true;
                showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                hideLoadingSpinner();
            }
        });

    });

    // Bei Klick auf Verantwortlichen Overlay öffnen
    jQuery(document).on('click', 'a.showResponsible', function () {
        showLoadingSpinner();

        let url = "/operator";
        let operator_id = jQuery(this).data("operatorid");

        $.get(url + '/' + operator_id, function (data) {

            if (data.response == "success") {
                jQuery("#loadingSpinner").hide();
                jQuery("#editorContent").html(data.editorHTML);
                jQuery("#listEditor").addClass("windowNarrow");
                jQuery("#listEditor").fadeIn();
            } else {
                error = true;
                showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                hideLoadingSpinner();
            }
        });
    });

    // Auftrag löschen: Overlay öffnen
    jQuery(document).on('click', 'a.deleteOrder', function () {
        showLoadingSpinner();

        // Ajax-Parameter festlegen
        var url = '/orders/deleteConfirm';
        var data = {};
        data["orderId"] = jQuery(this).data("orderid");

        // Handling für erfolgreichen Request
        successFunction = function (response) {
            if (response.response == "success") {
                jQuery("#loadingSpinner").hide();
                jQuery("#editorContent").html(response.editorHTML);
                jQuery("#listEditor").addClass("windowModal");
                jQuery("#listEditor").fadeIn();
            } else {
                errorFunction(response);
            }
        };

        // Handling für fehlerhaften Request
        errorFunction = function (response) {
            showModalBox("Es ist ein Fehler aufgetreten.", response.message);
            hideLoadingSpinner();
        };

        // Ajax aufrufen
        fireAjax(url, data, successFunction, errorFunction);
    });


    // Sortierfunktion: Parameter setzen
    jQuery(document).on('click', 'a.headerSortLink', function () {

        let sortStatus = jQuery(this).data("sortstatus");
        let sortId = jQuery(this).data("sortid");
        let newSortStatus = "";
        let newSortSymbol = "";

        // Neuen Sortierstatus setzen
        // Reihenfolge: Aufsteigend, Absteigend, nichts
        switch (sortStatus) {
            case "none":
                newSortStatus = "asc";
                break;
            case "asc":
                newSortStatus = "desc";
                break;
            case "desc":
            default:
                newSortStatus = "none";
        }

        // Sonderfall Auftragsnummer: hier gibts nur auf- und absteigend!
        if (sortId == "order_number" && newSortStatus == "none") {
            newSortStatus = "asc";
        }

        // Neuen Status setzen
        jQuery(this).data("sortstatus", newSortStatus);

        // Passendes Icon setzen
        switch (newSortStatus) {
            case "asc":
                newSortSymbol = "<i class=\"fas fa-sort-up\"></i>";
                break;
            case "desc":
                newSortSymbol = "<i class=\"fas fa-sort-down\"></i>";
                break;
            case "none":
            default:
                newSortSymbol = "<i class=\"fal fa-sort\"></i>";
        }

        jQuery("a.headerSortLink[data-sortid=" + sortId + "] span.sortSymbol").html(newSortSymbol);

        // Suche auslösen
        startSearch(entriesPerPage, 0, canCreateOrders, canEditOrders, canDeleteOrders, 0, listType, hideSensibleOrderData);

    });

</script>