@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')
    <main class="contentContainer">

        <h1>Auftragsstatus</h1>


        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                @if(UserController::checkRight("createOrderStatus", $user))
                    <a class="button editOrderStatus"
                       href="#"
                       data-orderstatusid="0">Neuen Auftragsstatus anlegen</a>
                @endif
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-10">
                        Auftragstatus
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @if(count($orderStatus) > 0)
                    @foreach($orderStatus as $orderStatusItem)
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-10 label">
                                {{ $orderStatusItem->label }}
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">

                                    <div class="">
                                        @if(UserController::checkRight("editOrderStatus", $user))
                                            <a href="#"
                                               data-orderstatusid="{{ $orderStatusItem->id }}"
                                               class="editOrderStatus"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteOrderStatus", $user))
                                            <a href="#"
                                               data-orderstatusid="{{ $orderStatusItem->id }}"
                                               class="deleteOrderStatus"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Auftragsstatus hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <script>

        jQuery(function () {

            // Auftragsstatus anlegen/bearbeiten: Overlay öffnen
            jQuery(".editOrderStatus").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/orderstatus';
                var data = {};
                data["orderStatusId"] = jQuery(this).data("orderstatusid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragsstatus löschen: Overlay öffnen
            jQuery(".deleteOrderStatus").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/orderstatus/deleteConfirm';
                var data = {};
                data["orderStatusId"] = jQuery(this).data("orderstatusid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>
@endsection
