<?php

use App\Http\Controllers\UserController;

if ($orderTag->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Auftragskennzeichen @if($mode=="create") anlegen @elseif($mode=="edit") bearbeiten @endif</header>

<div class="container">
    @if($mode=="create")
        {!! BootForm::open(["id" => "editOrderTag",
                             "route" => "orderTags.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @elseif($mode=="edit")
        {!! BootForm::open(["id" => "editOrderTag",
                             "route" => array("orderTags.update", $orderTag->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @endif


    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Auftragskennzeichen</label>
        <div class="col-12 col-lg-8">
            <input type="text" class="form-control" id="label" name="label"
                   value="{{ $orderTag->label }}">
        </div>
    </div>

    <div class="form-group row">
        <label for="order_types_id" class="col-12 col-lg-4 col-form-label">Auftragstyp</label>
        <div class="col-12 col-lg-8">
            <select class="form-control" id="order_types_id" name="order_types_id"
                    @if($mode == "edit") disabled="disabled" @endif>

                {{-- Wenn das Kennzeichen nur bearbeitet wird, darf der zugehörige Auftragstyp nicht mehr
                     bearbeitet werden --}}
                @if($mode == "edit")
                    <option value="{{ $orderTagOrderType->id }}"
                            selected="selected">{{ $orderTagOrderType->label }}</option>
                @else
                    {{-- Ansonsten alle verfügbaren Auftragstypen zur Auswahl stellen --}}
                    @foreach($allOrderTypes as $orderType)
                        <option value="{{ $orderType->id }}">{{ $orderType->label }}</option>
                    @endforeach
                    <option value="">Keine Zuordnung</option>
                @endif
            </select>
        </div>
    </div>
    {!! BootForm::close() !!}
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editOrderTag" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>


{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif

