@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;

?>

@section('content')
    <main class="contentContainer">

        <h1>Auftragskennzeichen</h1>

        <div class="row">
            <div class="col-12 col-md-4 text-md-center">
                @if(UserController::checkRight("createOrderTags", $user))
                    <a class="button editOrderTag"
                       href="#"
                       data-ordertagid="0">Neues Auftragskennzeichen anlegen</a>
                @endif
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-5">
                        Kennzeichen
                    </div>
                    <div class="col-5">
                        Auftragstyp
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @if(count($orderTags) > 0)
                    @foreach($orderTags as $orderTag)
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-5 label">
                                {{ $orderTag["label"] }}
                            </div>

                            <div class="col-5">
                                {{ $orderTag["order_type_label"] }}
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">

                                    <div class="">
                                        @if(UserController::checkRight("editOrderTags", $user))
                                            <a href="#"
                                               data-ordertagid="{{ $orderTag["id"] }}"
                                               class="editOrderTag"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteOrderTags", $user))
                                            <a href="#"
                                               data-ordertagid="{{ $orderTag["id"] }}"
                                               class="deleteOrderTag"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Auftragskennzeichen hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <script>

        jQuery(function () {

            // Auftragskennzeichen anlegen/bearbeiten: Overlay öffnen
            jQuery(".editOrderTag").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/ordertag';
                var data = {};
                data["orderTagId"] = jQuery(this).data("ordertagid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragskennzeichen löschen: Overlay öffnen
            jQuery(".deleteOrderTag").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/ordertags/deleteConfirm';
                var data = {};
                data["orderTagId"] = jQuery(this).data("ordertagid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });


        });
    </script>
@endsection
