@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')
    <main class="contentContainer">

        <h1>Auftragstypen</h1>


        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                @if(UserController::checkRight("createOrderTypes", $user))
                    <a class="button editOrderType"
                       href="#"
                       data-ordertypeid="0">Neuen Auftragstyp anlegen</a>
                @endif
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-5">
                        Auftragstyp
                    </div>
                    <div class="col-5">
                        Startstatus
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @if(count($orderTypes) > 0)
                    @foreach($orderTypes as $orderType)
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-5 label">
                                {{ $orderType->label }}
                            </div>

                            <div class="col-5">
                                {{ $orderType->order_statuses->label }}
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        @if(UserController::checkRight("editOrderTypes", $user))
                                            <a href="#"
                                               data-ordertypeid="{{ $orderType->id }}"
                                               class="editOrderType"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteOrderTypes", $user))
                                            <a href="#"
                                               data-ordertypeid="{{ $orderType->id }}"
                                               class="deleteOrderType"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Auftragstypen hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <script>

        jQuery(function () {
            // Auftragstyp anlegen/bearbeiten: Overlay öffnen
            jQuery(".editOrderType").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/ordertype';
                var data = {};
                data["orderTypeId"] = jQuery(this).data("ordertypeid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteOrderType").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/ordertypes/deleteConfirm';
                var data = {};
                data["orderTypeId"] = jQuery(this).data("ordertypeid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


@endsection
