<?php

use App\Textblock;

if ($product->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Artikel @if($mode=="create") anlegen @elseif($mode=="edit") bearbeiten @endif</header>


<div class="container">
    @if($mode=="create")
        {!! BootForm::open(["id" => "editProduct",
                             "route" => "products.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @elseif($mode=="edit")
        {!! BootForm::open(["id" => "editProduct",
                             "route" => array("products.update", $product->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @endif


    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Artikelnummer</label>
                <input type="text" name="product_number" id="product_number" class="form-control" value="{{ $product->product_number }}">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Bezeichnung</label>
                <input type="text" name="name" id="name" class="form-control" value="{{ $product->name }}">
            </div>
        </div>
    </div>

    <h3>Preisgestaltung</h3>

    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Preis 1</label>
                <input type="text" class="form-control" name="price_1" id="price_1" value="{{ $product->price_1 }}">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Preis 2</label>
                <input type="text" class="form-control" name="price_2" id="price_2" value="{{ $product->price_2 }}">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Preis 3</label>
                <input type="text" class="form-control" name="price_3" id="price_3" value="{{ $product->price_3 }}">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Preis 4</label>
                <input type="text" class="form-control" name="price_4" id="price_4" value="{{ $product->price_4 }}">
            </div>
        </div>
    </div>

</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editProduct" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

{!! BootForm::close() !!}

{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif
