@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
use App\Textblock;
?>

@section('content')
    <main class="contentContainer">

        <h1>Textbausteine</h1>

        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                @if(UserController::checkRight("createTextblocks", $user))
                    <a class="button editTextblock"
                       href="#"
                       data-textblockid="0">Neuen Textbaustein anlegen</a>
                @endif
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-2">
                        Typ
                    </div>
                    <div class="col-4">
                        Betreff
                    </div>
                    <div class="col-5">
                        Text
                    </div>
                </div>
                @if(count($textblocks) > 0)
                    @foreach($textblocks as $textblock)

                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-2">
                                {{ $textblock->getLabelForTextblockType() }}
                            </div>

                            <div class="col-4 label" style="word-break: break-word; padding-right: 10px;">
                                <a data-textblockid="{{ $textblock->id }}"
                                   class="editTextblock cursorPointer"
                                   title="Bearbeiten">{{ $textblock->subjectExcerpt(45) }}</a>
                            </div>

                            <div class="col-5" style="word-break: break-word; padding-right: 25px;">
                                {{ $textblock->textExcerpt(150) }}
                            </div>

                            <div class="col-1">
                                <div class="row no-gutters">
                                    <div class="">
                                        @if(UserController::checkRight("editTextblocks", $user))
                                            <a href="#"
                                               data-textblockid="{{ $textblock->id }}"
                                               class="editTextblock"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteTextblocks", $user) &&
                                            $textblock->type != Textblock::TEXTBLOCKTYPE_APPOINTMENTMAIL)
                                            <a href="#"
                                               data-textblockid="{{ $textblock->id }}"
                                               class="deleteTextblock"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Textbausteine hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')

    <script>
        // Neuen Textbaustein anlegen / Bestehenden bearbeiten
        jQuery(".editTextblock").click(function () {
            showLoadingSpinner();

            let url = "/conf/textblock";
            let textblock_id = jQuery(this).data("textblockid");

            $.get(url + '/' + textblock_id, function (response) {

                if (response.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(response.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                }
            });
        });

        // Textbaustein löschen: Overlay öffnen
        jQuery(".deleteTextblock").click(function () {
            showLoadingSpinner();

            // Ajax-Parameter festlegen
            var url = '/conf/textblocks/deleteConfirm';
            var data = {};
            data["textblockId"] = jQuery(this).data("textblockid");

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(response.editorHTML);
                    jQuery("#listEditor").addClass("windowModal");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    errorFunction(response);
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                hideLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);

        });
    </script>


@endsection
