<?php

use App\Http\Controllers\UserController;

?>

@extends('layouts.master')

@section('content')
    <main class="contentContainer">

        <h1>Wiedervorlagen</h1>

        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                <a class="button editOrderFollowUp"
                   href="#"
                   data-followupid="0">Wiedervorlage hinzufügen</a>
            </div>
        </div>
        <div class="clearfix">&nbsp;</div>

        <div class="row">
            <div class="col-lg-6 col-12">
                <div class="row">
                    <div class="col-12">
                        <h2>Heute</h2>
                    </div>
                </div>

                <div class="row no-gutters" data-itable='1'>
                    <div class="col-12">
                        <div class="row no-gutters listHeader">
                            <div class="col-2">
                                Auftrag
                            </div>
                            <div class="col-5">
                                Notiz
                            </div>
                            <div class="col-3">
                                Datum
                            </div>
                            <div class="col-2">
                                Aktionen
                            </div>
                        </div>

                        @if(count($followUpsUntilToday)>0)
                            @foreach($followUpsUntilToday as $followUp)
                                <div class="row no-gutters align-items-center listItem"
                                     data-followupid="{{ $followUp->id }}">


                                    <div class="col-2 label">
                                        <a href="{{ route('orders.edit', ["orderId" => $followUp->order_id]) }}">
                                            {{ $followUp->order->order_number }}
                                        </a>
                                    </div>
                                    <div class="col-5" style="word-break: break-word; padding-right: 10px;">
                                        {{ $followUp->note }}
                                    </div>
                                    <div class="col-3">
                                        {{ $followUp->nextUp }}
                                    </div>
                                    <div class="col-2">
                                        <div class="row">
                                            <div class="col-4">
                                                <a href="{{ route('orders.edit', ["orderId" => $followUp->order_id]) }}"
                                                   title="Auftrag ansehen">
                                                    <i class="fal fa-eye"></i>
                                                </a>
                                            </div>

                                            <div class="col-4">
                                                <a class="editOrderFollowUp cursorPointer"
                                                   data-followupid="{{ $followUp->id }}"
                                                   title="Bearbeiten">
                                                    <i class="fal fa-pencil-alt"></i>
                                                </a>
                                            </div>

                                            <div class="col-4">
                                                <a href="{{ route('orderFollowUp.destroy', ["followUpId" => $followUp->id]) }}"
                                                   title="Löschen">
                                                    <i class="fal fa-check-circle"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            @endforeach
                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Keine Wiedervorlagen hinterlegt.
                                </div>
                            </div>
                        @endif
                    </div>


                </div>
            </div>

            <div class="col-lg-6 col-12">
                <div class="row">
                    <div class="col-12">
                        <h2>Demnächst</h2>
                    </div>
                </div>

                <div class="row no-gutters" data-itable='1'>
                    <div class="col-12">
                        <div class="row no-gutters listHeader">
                            <div class="col-2">
                                Auftrag
                            </div>
                            <div class="col-5">
                                Notiz
                            </div>
                            <div class="col-3">
                                Datum
                            </div>
                            <div class="col-2">
                                Aktionen
                            </div>
                        </div>

                        <div id="followUpsFuture">
                            @if(count($followUpsFuture)>0)
                                @foreach($followUpsFuture as $followUp)
                                    <div class="row no-gutters align-items-center listItem"
                                         data-followupid="{{ $followUp->id }}">

                                        <div class="col-2 label">
                                            <a href="{{ route('orders.edit', ["orderId" => $followUp->order_id]) }}">
                                                {{ $followUp->order->order_number }}
                                            </a>
                                        </div>
                                        <div class="col-5" style="word-break: break-word; padding-right: 10px;">
                                            {{ $followUp->note }}
                                        </div>
                                        <div class="col-3">
                                            {{ $followUp->nextUp }}
                                        </div>
                                        <div class="col-2">
                                            <div class="row">
                                                <div class="col-4">
                                                    <a href="{{ route('orders.edit', ["orderId" => $followUp->order_id]) }}"
                                                       title="Bearbeiten">
                                                        <i class="fal fa-eye"></i>
                                                    </a>
                                                </div>
                                                <div class="col-4">
                                                    <a class="editOrderFollowUp cursorPointer"
                                                       data-followupid="{{ $followUp->id }}"
                                                       title="Bearbeiten">
                                                        <i class="fal fa-pencil-alt"></i>
                                                    </a>
                                                </div>
                                                <div class="col-4">
                                                    <a href="{{ route('orderFollowUp.destroy', ["followUpId" => $followUp->id]) }}"
                                                       title="Löschen">
                                                        <i class="fal fa-check-circle"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach
                            @else
                                <div id="noListEntries" class="row">
                                    <div class="col-12 text-center">
                                        Keine Wiedervorlagen hinterlegt.
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="divider-horizontal"></div>

        @if(UserController::checkRight("editFollowUps", $user))
            <h2>Wiedervorlagen anderer Nutzer</h2>
            <div class="row no-gutters" data-itable='1'>
                <div class="col-12">
                    <div class="row no-gutters listHeader">
                        <div class="col-2">
                            Nutzer
                        </div>
                        <div class="col-2">
                            Auftrag
                        </div>
                        <div class="col-3">
                            Notiz
                        </div>
                        <div class="col-3">
                            Datum
                        </div>
                        <div class="col-2">
                            Aktionen
                        </div>
                    </div>

                    <div id="otherFollowUps">
                        @if(count($otherFollowUps)>0)
                            @php $i = 0; @endphp

                            @foreach($otherFollowUps as $followUp)@if($i >= 5)
                                <div class="collapse" id="hiddenFollowUps"> @endif
                                    <div class="row no-gutters align-items-center listItem"
                                         data-followupid="{{ $followUp->id }}">
                                        <div class="col-2">
                                            {{ $followUp->operator->getName() }}
                                        </div>

                                        <div class="col-2 label">
                                            <a href="{{ route('orders.edit', ["orderId" => $followUp->order_id]) }}">
                                                {{ $followUp->order->order_number }}
                                            </a>
                                        </div>
                                        <div class="col-3" style="word-break: break-word; padding-right: 10px;">
                                            {{ $followUp->note }}
                                        </div>
                                        <div class="col-3">
                                            {{ $followUp->nextUp() }}
                                        </div>
                                        <div class="col-2">
                                            <div class="row">
                                                <div class="col-4">
                                                    <a href="{{ route('orders.edit', ["orderId" => $followUp->order_id]) }}"
                                                       title="Auftrag ansehen">
                                                        <i class="fal fa-eye"></i>
                                                    </a>
                                                </div>

                                                <div class="col-4">
                                                    <a class="editOrderFollowUp cursorPointer"
                                                       data-followupid="{{ $followUp->id }}"
                                                       title="Bearbeiten">
                                                        <i class="fal fa-pencil-alt"></i>
                                                    </a>
                                                </div>

                                                <div class="col-4">
                                                    <a href="{{ route('orderFollowUp.destroy', ["followUpId" => $followUp->id]) }}"
                                                       title="Löschen">
                                                        <i class="fal fa-check-circle"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                    </div>@if($i >= 5) </div> @endif

                            @php $i++; @endphp
                            @endforeach
                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Keine Wiedervorlagen hinterlegt.
                                </div>
                            </div>
                        @endif
                    </div>
                    @if(count($otherFollowUps) > 5)
                        <button class="btn btn-secondary btn-icon showMoreEntries"
                                id="showMoreFollowUps"
                                type="button"
                                data-status="less"
                                data-toggle="collapse"
                                data-target="#hiddenFollowUps"
                                aria-expanded="false">
                            <span><i class="fas fa-bell"></i></span>
                            <span class="buttonText">Mehr anzeigen</span></button>
                    @endif
                </div>


            </div>
        @endif
    </main>

    @include('layouts.overlay')


    <script>

        jQuery(document).on('click', '.editOrderFollowUp', function () {
            showLoadingSpinner();

            let followupid = jQuery(this).data("followupid");

            let url = "/followups/edit/0/" + followupid;

            $.get(url, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });

    </script>


@endsection
