<header>E-Mail erstellen</header>

<div class="alertContainer">
    <div class="alert alert-danger">
        <div class="alertIcon">
            <i class="far fa-exclamation-circle"></i>
        </div>
        <div class="errorMessage">
            <ul>
                <li></li>
            </ul>
        </div>
    </div>
</div>

<form id="addOrderMail" action="javascript:void(0);">

    <div class="container">

        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="to">Empfänger</label>
                    <input type="email" name="to" id="to" class="form-control"
                           value="{{ $mailTo }}">
                </div>
            </div>
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="mailTemplate">Textbaustein wählen</label>
                    <select class="form-control" id="mailTemplate">
                        @if(count($mailTemplates) > 0)
                            @foreach($mailTemplates as $mailTemplate)
                                <option value="{{ $mailTemplate->id }}"
                                        @if(isset($selectBlock) && $mailTemplate->id == $selectBlock)
                                        selected
                                        @endif
                                >{{ $mailTemplate->subject }}</option>
                            @endforeach
                        @endif
                        <option value="none"
                                @if(!(isset($selectBlock) && $mailTemplate->id == $selectBlock))
                                selected
                                @endif>- kein Baustein -
                        </option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label for="subject">Betreff</label>
                    <input type="text" name="subject" id="subject" class="form-control">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label for="text">Text</label>
                    <textarea name="text" id="text" name="text" class="form-control" rows="5"></textarea>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label for="orderDocuments">Anhänge</label>

                    <div style="max-height:175px; overflow:auto;">
                        <div class="row no-gutters listHeader">
                            <div class="col-1"></div>
                            <div class="col-1">Typ</div>
                            <div class="col-7">Dokument</div>
                            <div class="col-2">Größe</div>
                        </div>

                        @if(count($orderDocuments) > 0)
                            @foreach($orderDocuments as $orderDocumentId => $orderDocument)
                                <div class="row no-gutters listItem orderDocument">

                                    <div class="col-1">
                                        <label class="checkbox">
                                            <input type="checkbox"
                                                   name="orderDocuments[{{ $orderDocumentId }}]"
                                                   data-orderDocumentPath="{{ $orderDocument['path'] }}">
                                            <span class="checkmark"></span>
                                        </label>
                                    </div>

                                    <div class="col-1">
                                        {{ $orderDocument["mimetypeLabel"] }}
                                    </div>
                                    <div class="col-8" style="word-break: break-word; padding-right: 10px;">
                                        {{ $orderDocument["name"] }}
                                    </div>

                                    <div class="col-2">
                                        {{ $orderDocument["size"] }} {{ $orderDocument["sizeUnit"] }}
                                    </div>

                                </div>
                            @endforeach
                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Noch keine Dokumente zum Auftrag hinterlegt.
                                </div>
                            </div>
                        @endif
                    </div>

                </div>
            </div>
        </div>

        <input type="hidden" name="orderID" id="orderID" value="{{ $order->id }}">
        <input type="hidden" name="operatorID" id="operatorID" value="{{ $operatorID }}">
        <input type="hidden" name="operatorLabel" id="operatorLabel" value="{{ $operatorLabel }}">
    </div>
</form>

{{-- Textbausteine vorhalten --}}
@if(count($mailTemplates) > 0)
    @foreach($mailTemplates as $mailTemplate)
        <div class="hiddenMailTemplate" data-mailtemplateid="{{ $mailTemplate->id }}">
            <div class="subject">{{ $mailTemplate->subject }}</div>
            <div class="text">{{ $mailTemplate->text }}</div>
        </div>
    @endforeach
@endif


<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="addOrderMail" id="createOrderMail" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>
<script>
    jQuery(document).ready(function () {
        jQuery('select#mailTemplate').trigger("change");
    });

    // Bei Auswahl einer neuen Option Formular mit neuem Textbaustein vorausfüllen
    jQuery(document).on('change', 'select#mailTemplate', function () {
        let mailTemplateId = jQuery("select#mailTemplate option:selected").val();

        // Passenden Betreff und Text holen
        let mailSubject = jQuery("div.hiddenMailTemplate[data-mailtemplateid=" + mailTemplateId + "] .subject").html();
        let mailText = jQuery("div.hiddenMailTemplate[data-mailtemplateid=" + mailTemplateId + "] .text").html();

        // In Formular einfügen
        jQuery("input[name=subject]").val(mailSubject);
        jQuery("textarea[name=text]").val(mailText);

    });

    jQuery(document).on('click', 'button#createOrderMail', function () {
        showOverlayLoadingSpinner();
    });
</script>

{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif

