@extends('layouts.master')
<?php
use App\Library\DropzoneMulti;
use App\Http\Controllers\UserController;
use App\User;

$dropzoneOptions = [
    'acceptedFiles' => '"image/*,application/pdf,application/msword,application/vnd.ms-powerpoint,application/vnd.ms-excel,.xlsx,.xls,.doc,.docx,.ppt,.pptx,.msg"',
    'maxFilesize' => 15,
    'maxFiles' => 15
];


$projectDocumentDropzone = new DropzoneMulti(
    $dropzoneOptions,
    "editProject",
    "editProjectProjectDocumentsDropzone",
    "default", true, "fas fa-file",
    "newProjectFiles"
);

$articleDocumentDropzoneList = [];

if(isset($articleList))
{
    foreach($articleList as $article)
    {
        $articleDocumentDropzone = new DropzoneMulti(
            $dropzoneOptions,
            "editProject",
            "editProjectArticleDocumentsDropzone_" . $article->id,
            "default", true, "fas fa-file",
            "newArticleFiles_" . $article->id
        );

        array_push($articleDocumentDropzoneList, $articleDocumentDropzone);
    }
}


?>

@section('content')
    <main class="contentContainer">

        <h1>Projekt bearbeiten</h1>

        <button type="button" class="btn btn-primary btn-big additionalOrderSubmit"
                style="position: absolute; right: 10px; top: 10px;">
            Projekt speichern
        </button>

        {!! BootForm::open(["id" => "editProject",
                             "route" => "projects.update",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}

        <input type="hidden" name="orderToEdit" value="{{ $orderToEdit->id }}">



        <div class="row no-gutters listHeader">
            <div class="col-12">Grunddaten</div>
        </div>

        @if(!UserController::checkRight("hideSensibleOrderData", $user))
            <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label for="customer_id" class="col-12 col-form-label"><h5>Auftraggeber</h5></label>
                        <div class="col-12">
                            <div class="customerList">
                                <div class="row customerListControls">
                                    <div class="col-6">
                                        <div class="searchCustomer">
                                            <input type="text" class="slide-input search" id="searchFor"
                                                   autocomplete="off"
                                                   data-shownosearchresults="noOrderEditCustomers">
                                        </div>
                                    </div>
                                    <div class="col-6 text-right">
                                        @if(UserController::checkRight("createCustomers", $user))
                                            <label for="plusButton" title="Auftraggeber hinzufügen"
                                                   id="createNewCustomer">
                                                <i class="fas fa-plus-circle"></i></label>
                                        @endif
                                    </div>
                                </div>
                                <div id="customerList">
                                    {{-- Bisheriger Auftraggeber --}}
                                    <div class="customerItem"
                                         data-search-for="{{ $orderToEdit->customer->company }}">
                                        <label class="radio">
                                            {{ $orderToEdit->customer->company }}@if($orderToEdit->customer->place != ""), {{ $orderToEdit->customer->place }}@endif
                                            <input type="radio" name="customer_id"
                                                   value="{{ $orderToEdit->customer->id }}"
                                                   checked="checked">
                                            <div class="indicator"></div>
                                        </label>
                                    </div>
                                    {{-- Weitere Auftraggeber anzeigen --}}
                                    @foreach($customerList as $customer)
                                        @if($customer->id == $orderToEdit->customer_id)
                                            @continue
                                        @endif
                                        <div class="customerItem searchItem"
                                             data-search-for="{{ $customer->company }}">
                                            <label class="radio">
                                                {{ $customer->company }}@if($customer->place != ""), {{ $customer->place }}@endif

                                                <input type="radio" name="customer_id" value="{{ $customer->id }}">
                                                <div class="indicator"></div>
                                            </label>
                                        </div>
                                    @endforeach
                                </div>

                                <div data-nosearchresults="noOrderEditCustomers">Für diese Sucheingabe gibt es leider keine Ergebnisse.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    @if(UserController::checkRight("hideSensibleOrderData", $user))
                        @php $disableResponsibleSelect = "disabled"; @endphp
                    @else
                        @php $disableResponsibleSelect = ""; @endphp
                    @endif
                    @if(!UserController::checkRight("hideSensibleOrderData", $user))
                        <div class="row ">
                            @endif
                            <div class="{{ (UserController::checkRight("hideSensibleOrderData", $user))? "col-6" : "col-12"  }}">
                                <div class="form-group">
                                    <label for="responsible_operator_id" class="col-12 col-form-label"><h5>Verantwortliche
                                            Bearbeiter</h5>
                                    </label>
                                    <div class="col-12">
                                        <div class="inlineList">
                                            {{-- bereits zugewiesene Bearbeiter --}}
                                            @foreach($responsibleOperatorsList as $responsibleOperator)
                                                <div class="inlineListValue"
                                                     data-operatorid="{{ $responsibleOperator->id }}">
                                                    <div>
                                                        <label class="checkbox">{{ $responsibleOperator->getName() }}
                                                            <input type="checkbox"
                                                                   checked="checked"
                                                                   name="responsibleOperators[{{ $responsibleOperator->id }}]"
                                                                    {{$disableResponsibleSelect}}
                                                            >
                                                            <span class="checkmark"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach
                                            {{-- Weitere Bearbeiter --}}
                                            @if(!UserController::checkRight("hideSensibleOrderData", $user))
                                                @foreach($operatorsList as $operator)
                                                    <div class="inlineListValue" data-operatorid="{{ $operator->id }}">
                                                        <div>
                                                            <label class="checkbox">{{ $operator->getName() }}
                                                                <input type="checkbox"
                                                                       name="responsibleOperators[{{ $operator->id }}]"
                                                                >
                                                                <span class="checkmark"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-12 {{ (UserController::checkRight("hideSensibleOrderData", $user))? "" : "col-lg-6"  }}">
                <div class="row">
                    <div class="{{ (UserController::checkRight("hideSensibleOrderData", $user))? "col-6" : "col-12"  }}">
                        <div class="form-group">
                            <label for="order_type_id" class="col-12 col-form-label"><h5>Projekttyp</h5></label>
                            <div class="col-12">
                                <select class="form-control" id="project_type_id" name="project_type_id"
                                        @if(UserController::checkRight("hideSensibleOrderData", $user))
                                        disabled
                                        @endif
                                >
                                    <option value="" disabled selected>Bitte auswählen</option>
                                    @foreach($orderTypesList as $orderType)
                                        <option value="{{ $orderType->id }}"
{{--                                                data-orderstatus="{{ $orderType->order_statuses->id }}"--}}
                                                @if($orderType->id == $orderToEdit->project_type_id)
                                                selected
                                                @endif
                                        >{{ $orderType->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    @if(!UserController::checkRight("hideSensibleOrderData", $user))
                </div>
                @endif
            </div>


        </div>

        <br>
        <hr>
        <br>

        <div id="newFileContainerList">
{{--            <input type="hidden" id="newProjectFiles" name="newProjectFiles" value='{ "files": [], "fileSizes": [] }'>--}}
            <input type="hidden" id="newArticleFileFields" name="newArticleFileFields" value='{ "fields" : [ @foreach($articleDocumentDropzoneList as $articleDocumentDropzone) "{{$articleDocumentDropzone->dropzoneName}}"@if(!$loop->last),@endif @endforeach ] }'>
            <input type="hidden" id="documentFileFields" name="documentFileFields" value='{ "fields" : [] }'>

            {{--            @foreach($articleDocumentDropzoneList as $articleDocumentDropzone)--}}
{{--                <input type="hidden" id="{{$articleDocumentDropzone->dropzoneName}}" name="{{$articleDocumentDropzone->dropzoneName}}" value='{ "files": [], "fileSizes": [] }'>--}}
{{--            @endforeach--}}
        </div>

        {!! BootForm::close() !!}

        <div class="col-12">

            <h3>Projektspezifisch</h3>
            @include('document.documentList', array('dropzone' => $projectDocumentDropzone, 'documentList' => $orderToEdit->documents))

            @foreach($articleList as $key => $article)
                <br>
                <h3>Artikel {{$article->title}}</h3>
                @include('document.documentList', array('dropzone' => $articleDocumentDropzoneList[$key], 'documentList' => $article->documents))

            @endforeach

        </div>

    </main>

    @include('layouts.overlay')


    <script>
        jQuery(document).ready(function () {
            // Modifizierung der Auftragskennzeichen: Klick auf bereits zugewiesenes Kennzeichen
            jQuery(document).on('click', '#existingOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Input-Feld leeren und Kennzeichen in "Weitere Kennzeichen" verschieben
                jQuery("#existingOrderTags .orderTagValue[data-ordertag=" + orderTagId + "] input[type=text]").val("");
                jQuery("#existingOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#additionalOrderTags");

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Modifizierung der Auftragskennzeichen: Klick auf neues Kennzeichen
            jQuery(document).on('click', '#additionalOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Kennzeichen in "Neue Kennzeichen" verschieben
                jQuery("#additionalOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#newOrderTags");

                jQuery("#newOrderTags").fadeIn();
                jQuery(".orderTagHeader.newOrderTags").fadeIn();

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Modifizierung der Auftragskennzeichen: Klick auf neu hinzugefügtes Kennzeichen
            jQuery(document).on('click', '#newOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Input-Feld leeren und Kennzeichen in "Weitere Kennzeichen" verschieben
                jQuery("#newOrderTags .orderTagValue[data-ordertag=" + orderTagId + "] input[type=text]").val("");
                jQuery("#newOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#additionalOrderTags");

                // Wenn keine neu hinzugefügten Kennzeichen mehr da sind, Header ausblenden
                if (jQuery("#newOrderTags > *").length <= 0) {
                    jQuery(".orderTagHeader.newOrderTags").fadeOut();
                }

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Beim Tippen in ein Auftragskennzeichenwertefeld  // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
            jQuery("input[name^=ordertagsValues]").change(function () {
                jQuery("input#orderTagsChanged").val("1");
            });

            // Neuen Auftraggeber anlegen
            jQuery("#createNewCustomer").click(function () {
                showLoadingSpinner();
                let url = "/customer";
                let customer_id = 0;

                $.get(url + '/' + customer_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });

            });

            // Adresse hinzufügen
            jQuery("#addAddress").click(function () {
                showLoadingSpinner();
                let url = "/orders/new/addAddress";
                let address_id = 0;

                $.get(url + '/' + address_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });


            // Logeintrag hinzufügen: Layer öffnen
            jQuery("#addLogEntry").click(function () {
                showLoadingSpinner();
                let orderId = jQuery("input[name=orderToEdit]").val();
                let url = "/order/" + orderId + "/log/new";

                $.get(url, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

            // Auftragsmail versenden: Layer öffnen
            jQuery("#addOrderMail").click(function () {
                showLoadingSpinner();
                let orderId = jQuery("input[name=orderToEdit]").val();
                let url = "/ordermail/new/" + orderId;

                $.get(url, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });
        });

        // Adresseingaben verarbeiten
        jQuery(document).on('click', 'button#editOrderAddress', function () {

            // Eingabe validieren
            if (!jQuery("form#editOrderAddress").valid()) {
                showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
                return;
            }

            // Editierkennzeichen lesen
            let edit = jQuery("input#addressEdit").val();

            // Daten für eine neue Adresse aus dem Overlay holen und als JSON-Objekt speichern
            let newAddress = {};

            newAddress.name = jQuery("input#address_name").val();
            newAddress.firstname = jQuery("input#address_firstname").val();
            newAddress.company = jQuery("input#address_company").val();
            newAddress.street = jQuery("input#address_street").val();
            newAddress.house_number = jQuery("input#address_house_number").val();
            newAddress.address_addendum = jQuery("input#address_address_addendum").val();
            newAddress.zipcode = jQuery("input#address_zipcode").val();
            newAddress.place = jQuery("input#address_place").val();
            newAddress.country = jQuery("input#address_country").val();
            newAddress.telephone_number = jQuery("input#address_telephone_number").val();
            newAddress.note = jQuery("textarea#address_note").val();
            newAddress.email_final_customer = jQuery("input#address_email_final_customer").val();

            if (jQuery("input#addressExisted").val() == "true")
                newAddress.addressExisted = true;
            else
                newAddress.addressExisted = false;

            let jsonString = JSON.stringify(newAddress);


            let newIndex = 0;

            if (edit === "true") {
                let addressID = jQuery("input#addressID").val();

                // Bestehendes Input mit dieser Adress-ID löschen
                jQuery("input[data-addressindex='" + addressID + "']").remove();

                // Listeneintrag löschen
                jQuery("div.listItem[data-addressindex='" + addressID + "']").remove();

                newIndex = addressID;
            } else {
                // Letzten Adressindex finden
                let i = 0;

                jQuery("#addressInputsHidden > input[data-addressindex]").each(function () {
                    if (i <= jQuery(this).data("addressindex")) {
                        i = jQuery(this).data("addressindex");
                    }
                });

                // Neuen Index bestimmen
                newIndex = i + 1;
            }

            let newAddressInput = "<input type='hidden' data-addressindex='" + newIndex + "' " +
                "                         name='address[" + newIndex + "]' value='" + jsonString + "'>";

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("#addressInputsHidden").append(newAddressInput);

            // Adressenteaser für Liste bauen
            let addressAddendum = "";
            let company = "";
            if (newAddress.address_addendum != "") addressAddendum = newAddress.address_addendum;
            if (newAddress.company != "") company = newAddress.company;

            // Adresse zur Liste hinzufügen
            let addressItem = '<div class="row no-gutters listItem" data-addressindex="' + newIndex + '">\n' +
                '                                        <div class="col-10">\n' +
                '                                            <div class="row">\n' +
                '                                                <div class="col-1">\n' +
                '                                                    <i class="fas fa-home"></i>\n' +
                '                                                </div>\n' +
                '                                                <div class="col-4">\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Anschrift</strong>\n' +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.street + ' ' + newAddress.house_number +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                addressAddendum +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.zipcode + ' ' + newAddress.place +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.country +
                '                                                    </div>\n' +
                '                                                </div>\n' +
                '\n' +
                '                                                <div class="col-4">\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Ansprechpartner</strong>\n' +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                company +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.name + ' ' + newAddress.firstname +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Kontakt</strong>\n' +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                'Tel.: ' + newAddress.telephone_number +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                'E-Mail: ' + newAddress.email_final_customer +
                '                                                    </div>\n' +
                '                                                </div>\n' +
                '\n' +
                '                                                <div class="col-3">\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Zusätzliche Notiz</strong>\n' +
                '                                                    </div>\n' +
                '\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.note +
                '                                                    </div>\n' +
                '                                                </div>\n' +
                '                                            </div>\n' +
                '\n' +
                '\n' +
                '                                        </div>\n' +
                '\n' +
                '                                        <div class="col-1 offset-1 text-right">\n' +
                '                                            <div class="row no-gutters">\n' +
                '                                                <div class="">\n' +
                '                                                    <a href="#"\n' +
                '                                                       data-addressindex="' + newIndex + '"\n' +
                '                                                       data-addressexisted="' + newAddress.addressExisted + '"\n' +
                '                                                       class="editAddress cursorPointer"\n' +
                '                                                       title="Bearbeiten">\n' +
                '                                                        <i class="fal fa-pencil-alt"></i>\n' +
                '                                                    </a>\n' +
                '                                                </div>\n' +
                '<div class="">\n' +
                '                                                    <a data-addressindex="' + newIndex + '"\n' +
                '                                                       data-addressexisted="' + newAddress.addressExisted + '"\n' +
                '                                                       class="deleteAddress cursorPointer"\n' +
                '                                                       title="Bearbeiten">\n' +
                '                                                        <i class="fal fa-trash-alt"></i>\n' +
                '                                                    </a>\n' +
                '                                                </div>' +
                '                                            </div>\n' +
                '                                        </div>\n' +
                '                                    </div>';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#addressListItems #noListEntries").fadeOut();

            jQuery("#addressListItems").append(addressItem);
        });

        // Adresse bearbeiten
        jQuery(document).on('click', '.editAddress', function () {

            let addressID = jQuery(this).data("addressindex");
            let addressExisted = jQuery(this).data("addressexisted");

            showLoadingSpinner();
            let url = "/orders/new/addAddress";
            let address_id = 0;

            $.get(url + '/' + address_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);

                    // Editierkennzeichen, Adressen-ID und Löschfeld setzen
                    jQuery("input#addressEdit").val("true");
                    jQuery("input#addressID").val(addressID);
                    jQuery("button#deleteOrderAddress").data("addressindex", addressID);
                    jQuery("input#addressExisted").val(addressExisted);

                    // Daten aus zugehörigem Input holen
                    let jsonAddressData = jQuery("input[data-addressindex='" + addressID + "']").val();
                    let addressData = JSON.parse(jsonAddressData);

                    // Felder vorbelegen
                    jQuery("input#address_name").val(addressData.name);
                    jQuery("input#address_firstname").val(addressData.firstname);
                    jQuery("input#address_company").val(addressData.company);
                    jQuery("input#address_street").val(addressData.street);
                    jQuery("input#address_house_number").val(addressData.house_number);
                    jQuery("input#address_address_addendum").val(addressData.address_addendum);
                    jQuery("input#address_zipcode").val(addressData.zipcode);
                    jQuery("input#address_place").val(addressData.place);
                    jQuery("input#address_country").val(addressData.country);
                    jQuery("input#address_telephone_number").val(addressData.telephone_number);
                    jQuery("textarea#address_note").val(addressData.note);
                    jQuery("input#address_email_final_customer").val(addressData.email_final_customer);

                    jQuery("#listEditor").addClass("windowWide");
                    jQuery("#listEditor").fadeIn();
                } else {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });

        // Adresse löschen
        jQuery(document).on('click', '.deleteAddress', function () {
            let addressID = jQuery(this).data("addressindex");

            // Input mit dieser Adress-ID auslesen
            let jsonString = jQuery("input[data-addressindex='" + addressID + "']").val();
            let addressData = JSON.parse(jsonString);

            // Löschen-Flag nur setzen, wenn Adresse schon in der Datenbank existiert hat
            if (addressData.addressExisted === true) {
                addressData.deleteAddress = true;

                // Input-Wert aktualisieren
                jsonString = JSON.stringify(addressData);
                jQuery("input[data-addressindex='" + addressID + "']").val(jsonString);
            }
            // Ansonsten Input-Feld einfach löschen
            else {
                jQuery("input[data-addressindex='" + addressID + "']").remove();
            }


            // Listeneintrag wegblenden
            jQuery("div.listItem[data-addressindex='" + addressID + "']").addClass("markAsDeleted");
            jQuery("div.listItem[data-addressindex='" + addressID + "'] a").remove();
            jQuery("div.listItem[data-addressindex='" + addressID + "'] .actions").append("<i class=\"fas fa-minus-circle\"></i>");
            jQuery("#closeListEditor").trigger("click");
        });

        // Neuen Logeintrag verarbeiten
        jQuery(document).on('click', 'button#addOrderLog', function () {

            // Eingabe validieren
            if (!jQuery("form#addOrderLog").valid()) {
                showModalBox("Validierungsfehler", "")
                return;
            }

            // Daten für einen neuen Log aus dem Overlay holen und im JSON-Objekt speichern
            let newLog = {};
            newLog.operator_id = jQuery("input[name=operatorID]").val();
            newLog.operatorLabel = jQuery("input[name=operatorLabel]").val();
            newLog.order_id = jQuery("input[name=orderID]").val();
            newLog.text = jQuery("textarea#text").val();

            // Bisherige neu hinzugefügte Logs holen
            let jsonLogs = jQuery("input#newLogEntries").val();
            let logs = JSON.parse(jsonLogs);

            logs.logs.push(newLog);

            let newLogs = JSON.stringify(logs);

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("input#newLogEntries").val(newLogs);

            // Neue Log-Nachricht vorblenden
            let newLogListItem = '<div class="row no-gutters listItem userlog">\n' +
                '                            <div class="col-9">\n' +
                newLog.text +
                '                            </div>\n' +
                '                            <div class="col-2">\n' +
                newLog.operatorLabel +
                '                            </div>\n' +
                '                            <div class="col-1">\n' +
                '                                gerade eben \n' +
                '                            </div>\n' +
                '                        </div>';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#logEntries #noListEntries").fadeOut();

            jQuery("#logEntries").prepend(newLogListItem);
        });

        // Neue Auftrags-Email versenden und in Liste vorblenden
        jQuery(document).on('click', 'button#createOrderMail', function () {

            // Daten für eine neue Auftragsmail aus dem Overlay holen
            let newMail = {};
            newMail.operator_id = jQuery("input[name=operatorID]").val();
            newMail.order_id = jQuery("input[name=orderID]").val();
            newMail.to = jQuery("input[name=to]").val();
            newMail.subject = jQuery("input[name=subject]").val();
            newMail.text = jQuery("textarea#text").val();

            // Anhänge bzw. deren Pfade holen
            newMail.attachments = [];
            jQuery("input[data-orderDocumentPath]:checked").each(function () {
                newMail.attachments.push(jQuery(this).data("orderdocumentpath"));
            });

            // Für Vorblendung in Liste
            newMail.operatorLabel = jQuery("input[name=operatorLabel]").val();
            newMail.messageExcerpt = newMail.text.substring(0, 50) + "...";

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/ordermail/send';
            var data = {};
            data["newMail"] = JSON.stringify(newMail);

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {

                    // Erfolgsmeldung anzeigen
                    jQuery("#loadingSpinner").hide();
                    showModalBox("E-Mail erstellt", "Die E-Mail wurde im System  hinterlegt und wird demnächst versendet.");
                    jQuery("#listEditor").removeClass();
                    jQuery("#listOverlay").hide();

                    jQuery("#mailEntries #noListEntries").fadeOut();

                    // E-Mail in Historie vorblenden

                    let newMailLogEntry = ' <div class="row no-gutters listItem">\n' +
                        '                                        <div class="col-3">\n' +
                        '                                           <div class="row no-gutters label">\n' +
                        '                                               ' + newMail.subject + '<br>\n' +
                        '                                           </div>\n' +
                        '                                           <div class="row no-gutters">\n' +
                        '                                               ' + newMail.to + '\n' +
                        '                                           </div>\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-5" style="word-break: break-word; padding-right: 10px;">\n' +
                        '                                            ' + newMail.messageExcerpt + '\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-2">\n' +
                        '                                            ' + newMail.operatorLabel + '\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-2">\n' +
                        '                                            demnächst \n' +
                        '                                        </div>\n' +
                        '                                    </div>';


                    jQuery("#mailEntries").prepend(newMailLogEntry);
                } else {
                    errorFunction(response);
                }
                hideOverlayLoadingSpinner();
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showOverlayAlert(response.message);

                hideOverlayLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);
        });


        // Duplikatsprüfung
        jQuery(".additionalOrderSubmit").click(function () {
            showLoadingSpinner();

            let url = "/orders/duplicate";

            // Ajax-Request für das Nachladen des Overlay-Forms vorbereiten
            var token = jQuery('meta[name="csrf-token"]').attr('content');
            jQuery.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            $.post(url, jQuery("#editProject").serialize(), function (data) {

                if (data.response == "error") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    if (data.response != "duplicateExists")
                    {
                        jQuery("#editProject").submit();
                        hideLoadingSpinner();
                    }
                    else
                    {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                }
            });
        });

    </script>
@endsection
