<?php

use Carbon\Carbon;
use App\Http\Controllers\UserController;

$c = Carbon::now();
$today = $c->toDateString();
?>

@if(isset($preFilters) && count($preFilters) > 0)
    <div class="preFilters">

        @foreach($preFilters as $preFilterKey => $preFilterValue)
            <input type="hidden" data-filtertype="{{$preFilterKey}}" value="{{$preFilterValue}}">
        @endforeach

    </div>
@endif

@include('project.sections.filterSection')


{{-- Wenn Listenspalten ausgeblendet werden, weil hideSensibleOrderData zutrifft, andere Größen bestimmter Spalten
 verbreitern--}}
@if(UserController::checkRight("hideSensibleOrderData", $user))
    <style type="text/css">
        /* col-4 statt col-2 */
        div[data-content="address"] {
            flex: 0 0 33.333333%;
            max-width: 33.333333%;
        }

        /* col-3 statt col-2 */
        div[data-content="responsible"] {
            flex: 0 0 25%;
            max-width: 25%;
        }
    </style>
@endif

<div class="clearfix">&nbsp;</div>

<div class="row ordersList" id="listToSearch" data-itable='1'>
    <div class="col-12">
        <div class="row no-gutters listHeader">
            <div class="col-2">
                <a class="headerSortLink" data-sortStatus="desc" data-sortid="order_number">
                    P-Nr.
                    <span class="sortSymbol"><i class="fas fa-sort-down"></i></span>
                </a>
            </div>

            @if(!UserController::checkRight("hideSensibleOrderData", $user))
                <div class="col-2">
                    <a class="headerSortLink" data-sortStatus="none" data-sortid="customer_id">
                        Kunde
                        <span class="sortSymbol"><i class="fal fa-sort"></i></span>
                    </a>
                </div>
            @endif

            <div class="col-2" data-content="address">
                Projekttyp
            </div>
{{--            <div class="col-1" data-content="apartment_units">--}}
{{--                <a class="headerSortLink" data-sortStatus="none" data-sortid="apartment_units">--}}
{{--                    WE--}}
{{--                    <span class="sortSymbol"><i class="fal fa-sort"></i></span>--}}
{{--                </a>--}}
{{--            </div>--}}
{{--            <div class="col-1">--}}
{{--                <a class="headerSortLink" data-sortStatus="none" data-sortid="order_types_id">--}}
{{--                    A-Typ--}}
{{--                    <span class="sortSymbol"><i class="fal fa-sort"></i></span>--}}
{{--                </a>--}}
{{--            </div>--}}
            <div class="col-3" data-content="responsible">
                Verantw.
            </div>
            <div class="col-2">
                Erstellt
            </div>

{{--            @if(!UserController::checkRight("hideSensibleOrderData", $user))--}}
{{--                <div class="col-1">--}}
{{--                    <a class="headerSortLink" data-sortStatus="none" data-sortid="next_appointment">--}}
{{--                        Termin--}}
{{--                        <span class="sortSymbol"><i class="fal fa-sort"></i></span>--}}
{{--                    </a>--}}
{{--                </div>--}}
{{--            @endif--}}
            <div class="col-1">
                Aktionen
            </div>
        </div>
        <div id="ordersListItems">

        </div>
        <div id="noSearchResults" class="row">
            <div class="col-12 text-center">
                Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
            </div>
        </div>
    </div>
</div>

<div class="searchPagination">

</div>

</main>


@include('layouts.overlay')


@include('project.sections.generalListCode')
