<?php

use App\Http\Controllers\UserController;

if ($projectType->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Projekttyp @if($mode=="create") anlegen @elseif($mode=="edit") bearbeiten @endif</header>


<div class="container">
    @if($mode=="create")
        {!! BootForm::open(["id" => "editProjectType",
                             "route" => "projectTypes.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @elseif($mode=="edit")
        {!! BootForm::open(["id" => "editProjectType",
                             "route" => array("projectTypes.update", $projectType->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @endif


    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Projekttyp</label>
        <div class="col-12 col-lg-8">
            <input type="text" class="form-control" id="title" name="title"
                   value="{{ $projectType->title }}">
        </div>
    </div>

{{--    <div class="form-group row">--}}
{{--        <label for="order_statuses_id" class="col-12 col-lg-4 col-form-label">Startstatus</label>--}}
{{--        <div class="col-12 col-lg-8">--}}
{{--            <select class="form-control" name="order_statuses_id" id="order_statuses_id">--}}
{{--                @foreach($orderStatusList as $orderStatus)--}}
{{--                    @if($mode == "edit" && $orderStatus->id == $orderType->order_statuses_id)--}}
{{--                        <option value="{{ $orderStatus->id }}" selected>{{ $orderStatus->label }}</option>--}}
{{--                    @else--}}
{{--                        <option value="{{ $orderStatus->id }}">{{ $orderStatus->label }}</option>--}}
{{--                    @endif--}}
{{--                @endforeach--}}
{{--            </select>--}}
{{--        </div>--}}
{{--    </div>--}}
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editProjectType" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

{!! BootForm::close() !!}


{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif
