<?php

use App\Http\Controllers\UserController;

if ($customer->id == NULL) $mode = "create";
else $mode = "edit";

if ($mode == "edit")
    $route = "edit";
else
    $route = "new";
?>

<header>Kunde <?php if($mode=="create"): ?> anlegen <?php elseif($mode=="edit"): ?> <?php echo e($customer->company); ?> bearbeiten <?php endif; ?></header>

<div class="alertContainer">
    <div class="alert alert-danger">
        <div class="alertIcon">
            <i class="far fa-exclamation-circle"></i>
        </div>
        <div class="errorMessage">
            <ul>
                <li></li>
            </ul>
        </div>
    </div>
</div>

<form id="editCustomer" action="javascript:void(0);">

    <div class="container">

        <input type="hidden" id="customer_id" name="customer_id" value="<?php echo e($customer->id); ?>">
        <input type="hidden" id="client_id" name="client_id" value="<?php echo e($customer->client_id); ?>">
        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group row">
                    <div class="col-12">
                        <h3>Adressdaten</h3>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="company" class="col-12 col-lg-4 col-form-label">Firmenname</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               <?php if($mode=="edit"): ?> class="form-control-plaintext" readonly
                               <?php else: ?>              class="form-control"
                               <?php endif; ?>
                               id="company" name="company"
                               value="<?php echo e($customer->company); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="street" class="col-12 col-lg-4 col-form-label">Straße</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="street" name="street"
                               value="<?php echo e($customer->street); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="house_number" class="col-12 col-lg-4 col-form-label">Hausnummer</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="house_number" name="house_number"
                               value="<?php echo e($customer->house_number); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="zipcode" class="col-12 col-lg-4 col-form-label">Postleitzahl</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="zipcode" name="zipcode"
                               value="<?php echo e($customer->zipcode); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="place" class="col-12 col-lg-4 col-form-label">Ort</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="place" name="place"
                               value="<?php echo e($customer->place); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="country" class="col-12 col-lg-4 col-form-label">Land</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="country" name="country"
                               value="<?php echo e($customer->country); ?>">
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-6">
                <div class="form-group row">
                    <div class="col-12">
                        <h3>Kontaktperson</h3>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="title" class="col-12 col-lg-4 col-form-label">Anrede / Titel</label>
                    <div class="col-12 col-lg-8">
                        <select class="form-control" name="title" id="title">
                            <?php $__currentLoopData = $titleList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $titleLabel => $titleValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($titleValue); ?>"
                                        <?php if($titleValue == $customer->title): ?> selected <?php endif; ?>
                                ><?php echo e($titleLabel); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="name" class="col-12 col-lg-4 col-form-label">Name</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="name" name="name"
                               value="<?php echo e($customer->name); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="firstname" class="col-12 col-lg-4 col-form-label">Vorname</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="firstname" name="firstname"
                               value="<?php echo e($customer->firstname); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="email" class="col-12 col-lg-4 col-form-label">E-Mail-Adresse</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="email" name="email"
                               value="<?php echo e($customer->email); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="telephone_number" class="col-12 col-lg-4 col-form-label">Telefonnummer</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="telephone_number" name="telephone_number"
                               value="<?php echo e($customer->telephone_number); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="fax_number" class="col-12 col-lg-4 col-form-label">Faxnummer</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="fax_number" name="fax_number"
                               value="<?php echo e($customer->fax_number); ?>">
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group row">
                    <div class="col-12">
                        <h3>Preisgestaltung</h3>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="pricegroup" class="col-12 col-lg-4 col-form-label">Preisgruppe</label>
                    <div class="col-12 col-lg-8">
                      <select name="pricegroup" class="form-control">
                        <option value="1" <?php if($customer->pricegroup == 1): ?>
                        selected
                        <?php endif; ?>
                        >1</option>
                        <option value="2" <?php if($customer->pricegroup == 2): ?>
                        selected
                        <?php endif; ?>
                        >2</option>
                        <option value="3" <?php if($customer->pricegroup == 3): ?>
                        selected
                        <?php endif; ?>
                        >3</option>
                        <option value="4" <?php if($customer->pricegroup == 4): ?>
                        selected
                        <?php endif; ?>
                        >4</option>
                      </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editCustomer" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<script>
    jQuery(document).ready(function () {
        // Daten asynchron über Ajax speichern
        jQuery("button[type=submit][form=editCustomer]").click(function () {

            // Eingabe validieren
            if (!jQuery("form#editCustomer").valid()) {
                showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
                return;
            }

            var url = "/customer/<?php echo e($route); ?>";
            var data = {};

            data["customer_id"] = jQuery("input[name='customer_id']").val();
            data["client_id"] = jQuery("input[name='client_id']").val();
            data["company"] = jQuery("input[name='company']").val();
            data["title"] = jQuery("select[name='title']").val();
            data["name"] = jQuery("input[name='name']").val();
            data["firstname"] = jQuery("input[name='firstname']").val();
            data["street"] = jQuery("input[name='street']").val();
            data["house_number"] = jQuery("input[name='house_number']").val();
            data["zipcode"] = jQuery("input[name='zipcode']").val();
            data["place"] = jQuery("input[name='place']").val();
            data["country"] = jQuery("input[name='country']").val();
            data["telephone_number"] = jQuery("input[name='telephone_number']").val();
            data["fax_number"] = jQuery("input[name='fax_number']").val();
            data["email"] = jQuery("input[name='email']").val();
            data["pricegroup"] = jQuery("select[name='pricegroup']").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'post',
                url: url,
                data: data,
                dataType: 'json',
                success: function (data) {

                    if (data.response == "success") {
                        jQuery("#closeListEditor").trigger("click");

                        // Wenn die Funktion beim Auftrag anlegen aufgerufen wird, Auftraggeber als Option zur Liste hinzufügen
                        // und vorauswählen
                        if (jQuery("form#createOrder").length || jQuery("form#editOrder").length) {

                            if(data.newCustomer.place != null)
                                data.newCustomer.place = ', ' + data.newCustomer.place;
                            else
                                data.newCustomer.place = '';

                            let newCustomerListItem = '<div class="customerItem searchItem" data-search-for="' + data.newCustomer.company + '">\n' +
                                '                                    <label class="radio">' + data.newCustomer.company + data.newCustomer.place + '<br>\n' +
                                '                                        <input type="radio" name="customer_id" value="' + data.newCustomer.id + '"/>\n' +
                                '                                        <div class="indicator"></div>\n' +
                                '                                    </label>\n' +
                                '                                </div>';

                            jQuery("div#customerList").prepend(newCustomerListItem);

                            // Alle abwählen
                            jQuery("input[name='customer_id']").prop("checked", "");

                            // Hinzugefügtes wählen
                            jQuery("input[name='customer_id'][value='" + data.newCustomer.id + "']").click();
                        }

                        // Wenn die Funktion innerhalb einer Auftragsliste aufgerufen wird, muss nur der Auftraggebername und der Ort
                        // aktualisiert werden
                        else if (jQuery("div.ordersList").length > 0) {
                            showModalBox("Speichern erfolgreich", "Daten des Auftraggebers " + jQuery("input[name='company']").val() + " gespeichert.");
                            jQuery("a.showCustomer[data-customerid=" + jQuery("input[name='customer_id']").val() + "]")
                                .text(jQuery("input[name='company']").val() + " " + jQuery("input[name='place']").val());
                        }

                        else {
                            showModalBox("Speichern erfolgreich", "Daten des Auftraggebers " + jQuery("input[name='company']").val() + " gespeichert.");
                            jQuery("#modalBox").data("reload", "true");
                        }
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        showOverlayAlert(data.message);
                    }
                },
                error: function (data) {
                    //console.log(data);
                    showModalBox("Es ist ein Fehler aufgetreten.", "");
                    showOverlayAlert(data.message);
                }
            });
        });
    });

</script>



<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
<?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/customer/edit.blade.php ENDPATH**/ ?>