<?php

use App\Http\Controllers\UserController;

if ($projectType->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Projekttyp <?php if($mode=="create"): ?> anlegen <?php elseif($mode=="edit"): ?> bearbeiten <?php endif; ?></header>


<div class="container">
    <?php if($mode=="create"): ?>
        <?php echo BootForm::open(["id" => "editProjectType",
                             "route" => "projectTypes.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php elseif($mode=="edit"): ?>
        <?php echo BootForm::open(["id" => "editProjectType",
                             "route" => array("projectTypes.update", $projectType->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php endif; ?>


    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Projekttyp</label>
        <div class="col-12 col-lg-8">
            <input type="text" class="form-control" id="title" name="title"
                   value="<?php echo e($projectType->title); ?>">
        </div>
    </div>















</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editProjectType" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<?php echo BootForm::close(); ?>




<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
<?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/project_conf/project_types/edit.blade.php ENDPATH**/ ?>