<?php

use App\Http\Controllers\UserController;

?>

<header>Wiedervorlage <?php if($mode=="new"): ?> erstellen <?php else: ?> bearbeiten <?php endif; ?></header>


<div class="alertContainer">
    <div class="alert alert-danger">
        <div class="alertIcon">
            <i class="far fa-exclamation-circle"></i>
        </div>
        <div class="errorMessage">
            <ul>
                <li></li>
            </ul>
        </div>
    </div>
</div>

<div class="container">

    <form id="createOrderFollowUp" action="javascript:void(0);">
        <input type="hidden" name="mode" id="mode" value="<?php echo e($mode); ?>">
        <input type="hidden" name="followUpId" id="followUpId" value="<?php echo e($followUpId); ?>">
        <div class="form-group row">
            <label for="order_id" class="col-12 col-lg-4 col-form-label">Auftragsnummer</label>
            <div class="col-12 col-lg-8">
                <select class="form-control" name="order_id" id="order_id">
                    <?php $__currentLoopData = $orderIdsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderId => $orderNumber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($orderId); ?>"
                                <?php if($orderIdSelected==$orderId): ?> selected="selected"<?php endif; ?>
                        ><?php echo e($orderNumber); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <?php if(UserController::checkRight("editFollowUps", $user)): ?>
            <div class="form-group row">
                <label for="operator_id" class="col-12 col-lg-4 col-form-label">Bearbeiter</label>
                <div class="col-12 col-lg-8">
                    <select class="form-control" name="operator_id" id="operator_id">
                        <?php $__currentLoopData = $operatorsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($operator->id); ?>"
                                    <?php if($operatorSelected==$operator->id): ?> selected="selected"<?php endif; ?>
                            ><?php echo e($operator->getName()); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        <?php else: ?>
            <select class="form-control d-none" name="operator_id" id="operator_id">
                <option value="<?php echo e($loggedUser->operator->id); ?>"
                        selected="selected"><?php echo e($loggedUser->operator->getName()); ?></option>
            </select>
        <?php endif; ?>
        <div class="form-group row">
            <label for="note" class="col-12 col-lg-4 col-form-label">Notiz</label>
            <div class="col-12 col-lg-8">
                <textarea class="form-control" name="note" id="note" rows="2"><?php echo e($followUp->note); ?></textarea>
            </div>
        </div>
        <div class="form-group row">
            <label for="nextUp" class="col-12 col-lg-4 col-form-label">Datum</label>
            <div class="col-12 col-lg-8">
                <input type="date" class="form-control" name="nextUp" id="nextUp" value="<?php echo e($nextUp); ?>"
                       max="9999-12-31">
            </div>
        </div>
    </form>
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="createOrderFollowUp" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<script>
    // Daten asynchron über Ajax speichern
    jQuery(document).on("click", "button[form=createOrderFollowUp]", function () {
        jQuery(document).off("click", "button[form=createOrderFollowUp]");

        // Eingabe validieren
        if (!jQuery("form#createOrderFollowUp").valid()) {
            showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
            return;
        }

        nextUp = JSON.parse('{"date": "<?php echo e($nextUp); ?>"}');
        let mode = jQuery("#mode").val();
        let followUpId = jQuery("#followUpId").val();

        var url = "/followups/" + mode;

        let newFollowUp = {};
        newFollowUp.order_id = jQuery("select[name=order_id]").val();
        newFollowUp.note = jQuery("textarea[name=note]").val();
        newFollowUp.nextUp = jQuery("input[name=nextUp]").val();

        // Wenn Datum leer, vorgefertigtes setzen
        if (newFollowUp.nextUp == "" || newFollowUp.nextUp == undefined) {
            newFollowUp.nextUp = nextUp.date;
        }

        newFollowUp.operator_id = jQuery("select[name=operator_id]").val();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Ajax-Parameter festlegen
        var data = {data: JSON.stringify(newFollowUp), followUpId: followUpId},

            // Handling für erfolgreichen Request
            successFunction = function (data) {
                if (data.response == "success") {

                    let newFollowUp = data.newFollowUp;
                    let followUpFor = data.followUpFor;

                    // Vorblenden in Liste für Wiedervorlagen
                    if (jQuery("div#followUpsFuture").length) {

                        // Bei Update alten Eintrag löschen
                        if (mode == "update") {
                            jQuery(".listItem[data-followupid=" + followUpId + "]").remove();
                        }

                        // In eigener Liste vorblenden
                        if (followUpFor == "own") {
                            let newEntry = '<div class="row no-gutters align-items-center listItem newEntry"' +
                                '                                     data-followupid="' + newFollowUp.id + '">\n' +
                                '\n' +
                                '                                    <div class="col-2 label">\n' +
                                '                                        <a href="/order/' + newFollowUp.order_id + '">\n' +
                                '                                            ' + newFollowUp.orderNumber + '\n' +
                                '                                        </a>\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-5"  style="word-break: break-word; padding-right: 10px;">\n' +
                                '                                        ' + newFollowUp.note + '\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-3">\n' +
                                '                                        ' + newFollowUp.nextUp + '\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-2">\n' +
                                '                                        <div class="row">\n' +
                                '                                            <div class="col-4">\n' +
                                '                                                <a href="/order/' + newFollowUp.order_id + '">\n' +
                                '                                                    <i class="fal fa-eye"></i>\n' +
                                '                                                </a>\n' +
                                '                                            </div>\n' +
                                '<div class="col-4">\n' +
                                '                                                <a class="editOrderFollowUp cursorPointer"\n' +
                                '                                                   data-followupid="' + newFollowUp.order_id + '"\n' +
                                '                                                   title="Bearbeiten">\n' +
                                '                                                    <i class="fal fa-pencil-alt"></i>\n' +
                                '                                                </a>\n' +
                                '                                            </div>' +
                                '\n' +
                                '                                            <div class="col-4">\n' +
                                '                                                <a href="/orders/followups/delete/' + newFollowUp.id + '"\n' +
                                '                                                   title="Löschen"' + '>\n' +
                                '                                                    <i class="fal fa-check-circle"></i>\n' +
                                '                                                </a>\n' +
                                '                                            </div>\n' +
                                '                                        </div>\n' +
                                '                                    </div>\n' +
                                '\n' +
                                '                                </div>';
                            jQuery("div#followUpsFuture").prepend(newEntry);
                        }
                        // In Liste anderer vorblenden
                        else if (followUpFor == "notown") {
                            let newEntry = '<div class="row no-gutters align-items-center listItem newEntry"' +
                                '                                     data-followupid="' + newFollowUp.id + '">\n' +
                                '\n' +
                                '                                    <div class="col-2">\n' +
                                '                                            ' + newFollowUp.operatorName + '\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-2 label">\n' +
                                '                                        <a href="/order/' + newFollowUp.order_id + '">\n' +
                                '                                            ' + newFollowUp.orderNumber + '\n' +
                                '                                        </a>\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-3"  style="word-break: break-word; padding-right: 10px;">\n' +
                                '                                        ' + newFollowUp.note + '\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-3">\n' +
                                '                                        ' + newFollowUp.nextUp + '\n' +
                                '                                    </div>\n' +
                                '                                    <div class="col-2">\n' +
                                '                                        <div class="row">\n' +
                                '                                            <div class="col-4">\n' +
                                '                                                <a href="/order/' + newFollowUp.order_id + '">\n' +
                                '                                                    <i class="fal fa-eye"></i>\n' +
                                '                                                </a>\n' +
                                '                                            </div>\n' +
                                '<div class="col-4">\n' +
                                '                                                <a class="editOrderFollowUp cursorPointer"\n' +
                                '                                                   data-followupid="' + newFollowUp.order_id + '"\n' +
                                '                                                   title="Bearbeiten">\n' +
                                '                                                    <i class="fal fa-pencil-alt"></i>\n' +
                                '                                                </a>\n' +
                                '                                            </div>' +
                                '\n' +
                                '                                            <div class="col-4">\n' +
                                '                                                <a href="/orders/followups/delete/' + newFollowUp.id + '"\n' +
                                '                                                   title="Löschen">\n' +
                                '                                                    <i class="fal fa-check-circle"></i>\n' +
                                '                                                </a>\n' +
                                '                                            </div>\n' +
                                '                                        </div>\n' +
                                '                                    </div>\n' +
                                '\n' +
                                '                                </div>';
                            jQuery("div#otherFollowUps").prepend(newEntry);
                        }

                        jQuery("#followUpsFuture #noListEntries").fadeOut();
                    }

                    // Vorblenden in Auftragsanlage
                    if (jQuery("form#editOrder").length > 0) {

                        let newEntry = '<div class="row no-gutters listItem newEntry" data-followupid="' + newFollowUp.id + '">\n' +
                            '                                        <div class="col-3">\n' +
                            '                                            ' + newFollowUp.operatorName + '\n' +
                            '                                        </div>\n' +
                            '                                        <div class="col-3">\n' +
                            '                                        ' + newFollowUp.nextUp +
                            '                                        </div>\n' +
                            '                                        <div class="col-4">\n' +
                            '                                        ' + newFollowUp.note +
                            '                                        </div>\n' +
                            '\n' +
                            '\n' +
                            '                                        <div class="col-2">\n' +
                            '                                                <div class="row no-gutters align-items-center actions">\n' +
                            '                                                    <div class="col-md-4">\n' +
                            '                                                        <a class="editOrderFollowUp cursorPointer"' +
                            '                                                           data-followupid="' + newFollowUp.id +
                            '                                                        "><i class="fal fa-pencil-alt"></i></a>\n' +
                            '                                                    </div>\n' +
                            '                                                    <div class="col-md-4">\n' +
                            '                                                        <a class="deleteOrderFollowUp cursorPointer"\n' +
                            '                                                           data-followupid="' + newFollowUp.id +
                            '                                                        "><i class="fal fa-check-circle"></i></a>\n' +
                            '                                                    </div>\n' +
                            '                                                </div>\n' +
                            '\n' +
                            '                                        </div>\n' +
                            '\n' +
                            '                                    </div>\n';

                        // Bei Update alten Eintrag ausblenden
                        if (mode == "update") {
                            jQuery(".listItem[data-followupid=" + followUpId + "]").remove();
                        }

                        jQuery("#followUps #noListEntries").fadeOut();

                        jQuery("div#followUps").prepend(newEntry);
                    }

                    jQuery("#closeListEditor").trigger("click");
                    showModalBox("Wiedervorlage gespeichert", "");
                }
                else {
                    showOverlayAlert("Es ist ein Fehler aufgetreten. " + data.message);
                }
            };

        // Handling für fehlerhaften Request
        errorFunction = function (data) {
            showOverlayAlert("Es ist ein Fehler aufgetreten. " + data.message);
        };

        // Ajax aufrufen
        fireAjax(url, data, successFunction, errorFunction);
    });
</script>



<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
