<?php
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Verfahrensanweisungen</h1>


        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                <?php if(UserController::checkRight("createOrderType", $user)): ?>
                    <a class="button editProceduralInstruction"
                       href="#"
                       data-proceduralinstructionid="0">Neue Verfahrensanweisung anlegen</a>
                <?php endif; ?>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-5">
                        Verfahrensanweisung
                    </div>
                    <div class="col-5">
                        Hinterlegte Dokumente
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <?php if(count($proceduralInstructionList) > 0): ?>
                    <?php $__currentLoopData = $proceduralInstructionList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proceduralInstruction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-5 label">
                                <?php echo e($proceduralInstruction->title); ?>

                            </div>

                            <div class="col-5">
                                <i class="fas fa-file-powerpoint" style="margin-right:0; font-size:1.2em; color:#df7e1b;"></i> <span>PowerPoint</span> <span class="badge badge-pill badge-light">15</span> <br>
                                <i class="fas fa-file-word" style="margin-right:0; font-size:1.2em;color:#2230d5;"></i> Word <span class="badge badge-pill badge-light">2</span> <br>
                                <i class="fas fa-file-excel" style="margin-right:0; font-size:1.2em;color:#138b13;"></i> Excel <span class="badge badge-pill badge-light">3</span> <br>
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        <?php if(UserController::checkRight("editProceduralInstruction", $user)): ?>
                                            <a href="#"
                                               data-proceduralinstructionid="<?php echo e($proceduralInstruction->id); ?>"
                                               class="editProceduralInstruction"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                    <div class="">
                                        <?php if(UserController::checkRight("deleteProceduralInstruction", $user)): ?>
                                            <a href="#"
                                               data-proceduralInstructionid="<?php echo e($proceduralInstruction->id); ?>"
                                               class="deleteProceduralInstruction"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Verfahrensanweisungen hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>

        jQuery(function () {
            // Auftragstyp anlegen/bearbeiten: Overlay öffnen
            jQuery(".editProceduralInstruction").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/proceduralinstruction';
                var data = {};
                data["proceduralInstructionId"] = jQuery(this).data("proceduralinstructionid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteProceduralInstruction").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/proceduralinstruction/deleteConfirm';
                var data = {};
                data["proceduralInstructionId"] = jQuery(this).data("proceduralinstructionid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/procedural_instruction/list.blade.php ENDPATH**/ ?>