<?php
use App\Operator;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>


    <main class="contentContainer">

        <h1>Bearbeiter</h1>

        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-12 col-md-3 text-center">
                        <?php if(UserController::checkRight("createOperators", $user)): ?>
                            <a class="button editOperator"
                               href="#"
                               data-operatorid="0">Neuen Bearbeiter anlegen</a>
                        <?php endif; ?>
                    </div>

                    <div class="col-12 col-md-3 offset-md-6 text-right">
                        <input type="text" class="slide-input search" id="searchFor" autocomplete="off"
                               data-shownosearchresults="noOperators">
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row operatorList" id="listToSearch" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters operatorListHeader listHeader">
                    <div class="col-4" style="padding-left:0px;">
                        Bearbeiter
                    </div>
                    <div class="col-3">
                        Kontakt
                    </div>
                    <div class="col-3">
                        Firma
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <?php $__currentLoopData = $operatorList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row no-gutters align-items-center searchItem listItem"
                         data-search-for="<?php echo e($operator->name); ?> <?php echo e($operator->firstname); ?>">


                        <div class="col-4">
                            <div class="row">
                                <div class="col-2 itablehidemobile">
                                    <div class="img"
                                         style="background-image: url('<?php echo e($operator->getImage()); ?>');"></div>
                                </div>
                                <div class="col-10 mb-auto mt-auto">
                                    <div class="row">
                                        <div class="col-12 label">
                                            <a class="editOperator cursorPointer"
                                               data-operatorid="<?php echo e($operator->id); ?>"
                                               title="Bearbeiten">
                                                <?php echo e($operator->getName()); ?>

                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <?php if($operator->position == "" && $operator->company != ""): ?>
                                                Extern
                                            <?php else: ?>
                                                <?php echo e($operator->position); ?>

                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-3">
                            <?php if($operator->email == "" && $operator->phone == ""): ?>
                                -
                            <?php else: ?>
                                <div class="row no-gutters">
                                    <div class="col-12">
                                        <a href="mailto:<?php echo e($operator->email); ?>"><?php echo e($operator->email); ?></a>
                                    </div>
                                </div>
                                <div class="row no-gutters">
                                    <div class="col-12">
                                        <?php if($operator->phone != ""): ?>
                                            Tel.: <?php echo e($operator->phone); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>

                            <?php endif; ?>
                        </div>

                        <div class="col-3">
                            <?php if(isset($operator->company)): ?> <?php echo e($operator->company); ?><?php endif; ?>
                        </div>

                        <div class="col-2">
                            <div class="row no-gutters">

                                <div class="">
                                    <?php if(UserController::checkRight("editOperators", $user)): ?>
                                        <a href="#"
                                           data-operatorid="<?php echo e($operator->id); ?>"
                                           class="editOperator"
                                           title="Bearbeiten">
                                            <i class="fal fa-pencil-alt"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>












                                <div class="">
                                    <?php if(UserController::checkRight("createUser", $user) && $operator->user==null): ?>
                                        <a href="#"
                                           data-operatorid="<?php echo e($operator->id); ?>"
                                           class="createUser"
                                           title="Benutzer erstellen">
                                            <i class="fas fa-user-plus"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div data-nosearchresults="noOperators" class="row">
                    <div class="col-12 text-center">
                        Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
                    </div>
                </div>
            </div>
        </div>

    </main>


    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>

        jQuery(function () {
            // Neuen Auftraggeber anlegen / Bestehenden bearbeiten
            jQuery(".editOperator").click(function () {
                showLoadingSpinner();

                let url = "/operator";
                let operator_id = jQuery(this).data("operatorid");

                $.get(url + '/' + operator_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

            // Benutzer erstellen
            jQuery(".createUser").click(function () {
                showLoadingSpinner();

                let url = "/operator/newUserConfirm";
                let operator_id = jQuery(this).data("operatorid");

                $.get(url + '/' + operator_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/operator/list.blade.php ENDPATH**/ ?>