<?php echo BootForm::open(["id" => "deleteOrder",
                   "route" => array('orders.delete'),
                   "method" => "POST",
                   "enctype" => "multipart/form-data"]); ?>

<div>
    <header>Auftrag löschen</header>

    <div class="container">

        <div class="row">
            <div class="col-md-12">
                <p>Bist du dir sicher, dass du den Auftrag mit der Nummer <strong><?php echo e($order->order_number); ?></strong> löschen möchtest?</p>
                <p><strong>Auftraggeber: </strong> <?php echo e($order->customerName); ?></p>
                <p><strong>Auftragstyp: </strong> <?php echo e($order->order_type_label); ?></p>
            </div>
        </div>


        <div class="row align-items-center">
            <div class="col-md-10">
                Bitte bestätige das Löschen, indem du die Checkbox aktivierst.
                <input type="hidden" name="orderToDelete" value="<?php echo e($order->id); ?>">
            </div>

            <div class="col-md-2">
                <label class="toggleCheckbox">
                    <input type="checkbox" name="confirmDelete">
                    <i class="bigger"></i>
                </label>
            </div>
        </div>


        <div class="alert alert-danger">
            <div class="alertIcon">
                <i class="far fa-exclamation-circle"></i>
            </div>
            <div>
                Diese Aktion kann nicht rückgängig gemacht werden.
            </div>
        </div>
    </div>
</div>



<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" class="btn btn-primary">
                Auftrag #<?php echo e($order->id); ?> löschen
            </button>
        </div>
    </div>
</footer>

<?php echo BootForm::close(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/order/deleteOrder.blade.php ENDPATH**/ ?>