<?php
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>


    <main class="contentContainer">

        <h1>Projekte <?php if(isset($preFilteredByCustomer) && $preFilteredByCustomer==true): ?>
                von <?php echo e($preFilteredCustomer); ?><?php endif; ?></h1>

        <?php if(UserController::checkRight("createOrders", $user)): ?>
            <a class="button" style="width: 400px; text-align: center; position:absolute;top:25px;right:10px;"
               href="<?php echo e(route('projects.create')); ?>">Neues Projekt anlegen</a>
        <?php endif; ?>


        <?php echo $__env->make('project.listSection', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <script>
            let listType = "ordersList";

            $(document).ready(function(){
                setTimeout(checkPendingProjects, 1000);
            });

            function checkPendingProjects()
            {
                $('.listItem[data-loading="true"]').each(function(){
                    // debugger;
                    var projectItem = this;
                    $.get("/checkProjectStatus/" + $(this).data("projectid"), function(data, status) {
                        var projectJsonData = JSON.parse(data);
                        if(projectJsonData.status == "created")
                        {
                            $(projectItem).data("loading","");
                            $('[data-projectid="' + projectJsonData.id + '"] .loading-gif').slideUp();
                            $('[data-projectid="' + projectJsonData.id + '"] .actions').fadeIn();
                        }
                    });
                });

                setTimeout(checkPendingProjects, 1000);
            }

        </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/project/list.blade.php ENDPATH**/ ?>